<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class ResetAdminPassword extends Command
{
    protected $signature = 'admin:reset-password';
    protected $description = 'Reset admin user password';

    public function handle()
    {
        $user = User::where('email', 'admin@microloan.com')->first();
        
        if (!$user) {
            $this->error('Admin user not found!');
            return 1;
        }

        // Update password directly using DB to bypass model casting
        DB::table('users')
            ->where('email', 'admin@microloan.com')
            ->update([
                'password' => Hash::make('admin123'),
                'role' => 'admin',
            ]);

        $this->info('Admin password has been reset to: admin123');
        $this->info('Email: admin@microloan.com');
        
        return 0;
    }
}

