<?php

namespace App\Http\Controllers\Partner;

use App\Http\Controllers\Controller;
use App\Models\Partner;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        $partner = auth()->user()->partner;
        return view('partner.settings.index', compact('partner'));
    }

    public function update(Request $request)
    {
        $partner = auth()->user()->partner;
        
        $validated = $request->validate([
            // Customer Settings
            'customer_prefix' => 'nullable|string|max:20',
            'customer_suffix' => 'nullable|string|max:20',
            'customer_number_type' => 'required|in:sequential,random',
            'customer_last_number' => 'nullable|integer|min:0',
            
            // Loan Settings
            'loan_prefix' => 'nullable|string|max:20',
            'loan_suffix' => 'nullable|string|max:20',
            'loan_number_type' => 'required|in:sequential,random',
            'loan_last_number' => 'nullable|integer|min:0',
            
            // Savings Settings
            'savings_prefix' => 'nullable|string|max:20',
            'savings_suffix' => 'nullable|string|max:20',
            'savings_number_type' => 'required|in:sequential,random',
            'savings_last_number' => 'nullable|integer|min:0',
        ]);

        $partner->update($validated);

        return redirect()->route('partner.settings.index')->with('success', 'Number format settings updated successfully.');
    }
}
