<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SavingsCollection extends Model
{
    protected $fillable = [
        'partner_id',
        'saving_id',
        'customer_id',
        'collection_number',
        'amount',
        'collection_date',
        'due_date',
        'payment_method',
        'reference_number',
        'notes',
    ];

    protected function casts(): array
    {
        return [
            'amount' => 'decimal:2',
            'collection_date' => 'date',
            'due_date' => 'date',
        ];
    }

    public function partner(): BelongsTo
    {
        return $this->belongsTo(Partner::class);
    }

    public function savingsAccount(): BelongsTo
    {
        return $this->belongsTo(Saving::class, 'saving_id');
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }
}
