<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update loans table
        Schema::table('loans', function (Blueprint $table) {
            $table->enum('duration_type', ['daily', 'weekly', 'monthly'])->default('monthly')->after('interest_rate');
            $table->renameColumn('duration_months', 'duration_value');
        });

        // Update savings table
        Schema::table('savings', function (Blueprint $table) {
            $table->enum('duration_type', ['daily', 'weekly', 'monthly'])->default('monthly')->after('interest_rate');
            $table->integer('duration_value')->nullable()->after('duration_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert loans table
        Schema::table('loans', function (Blueprint $table) {
            $table->dropColumn('duration_type');
            $table->renameColumn('duration_value', 'duration_months');
        });

        // Revert savings table
        Schema::table('savings', function (Blueprint $table) {
            $table->dropColumn(['duration_type', 'duration_value']);
        });
    }
};
