<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('schemes', function (Blueprint $table) {
            $table->enum('interest_type', ['flat', 'percentage'])->default('percentage')->after('interest_rate');
            $table->enum('duration_type', ['daily', 'weekly', 'monthly'])->nullable()->after('duration_months');
            $table->integer('duration_value')->nullable()->after('duration_type');
            $table->decimal('processing_fee', 15, 2)->default(0)->after('max_amount');
            $table->decimal('insurance_fee', 15, 2)->default(0)->after('processing_fee');
            $table->decimal('other_fee', 15, 2)->default(0)->after('insurance_fee');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('schemes', function (Blueprint $table) {
            $table->dropColumn([
                'interest_type',
                'duration_type',
                'duration_value',
                'processing_fee',
                'insurance_fee',
                'other_fee'
            ]);
        });
    }
};
