<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->decimal('processing_fee', 15, 2)->default(0)->after('interest_rate');
            $table->decimal('insurance_fee', 15, 2)->default(0)->after('processing_fee');
            $table->decimal('other_fee', 15, 2)->default(0)->after('insurance_fee');
            $table->decimal('interest_amount', 15, 2)->default(0)->after('other_fee');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->dropColumn(['processing_fee', 'insurance_fee', 'other_fee', 'interest_amount']);
        });
    }
};
