<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('schemes', function (Blueprint $table) {
            $table->enum('late_fee_type', ['percentage', 'fixed'])->nullable()->after('other_fee');
            $table->decimal('late_fee_value', 15, 2)->default(0)->after('late_fee_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('schemes', function (Blueprint $table) {
            $table->dropColumn(['late_fee_type', 'late_fee_value']);
        });
    }
};
