<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('partners', function (Blueprint $table) {
            // Customer ID/Account Number Settings
            $table->string('customer_prefix')->nullable()->after('logo');
            $table->string('customer_suffix')->nullable()->after('customer_prefix');
            $table->enum('customer_number_type', ['sequential', 'random'])->default('sequential')->after('customer_suffix');
            $table->integer('customer_last_number')->default(0)->after('customer_number_type');
            
            // Loan Number Settings
            $table->string('loan_prefix')->nullable()->after('customer_last_number');
            $table->string('loan_suffix')->nullable()->after('loan_prefix');
            $table->enum('loan_number_type', ['sequential', 'random'])->default('sequential')->after('loan_suffix');
            $table->integer('loan_last_number')->default(0)->after('loan_number_type');
            
            // Savings Number Settings
            $table->string('savings_prefix')->nullable()->after('loan_last_number');
            $table->string('savings_suffix')->nullable()->after('savings_prefix');
            $table->enum('savings_number_type', ['sequential', 'random'])->default('sequential')->after('savings_suffix');
            $table->integer('savings_last_number')->default(0)->after('savings_number_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('partners', function (Blueprint $table) {
            $table->dropColumn([
                'customer_prefix',
                'customer_suffix',
                'customer_number_type',
                'customer_last_number',
                'loan_prefix',
                'loan_suffix',
                'loan_number_type',
                'loan_last_number',
                'savings_prefix',
                'savings_suffix',
                'savings_number_type',
                'savings_last_number',
            ]);
        });
    }
};
