<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('text'); // text, json, encrypted
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default Razorpay settings
        DB::table('settings')->insert([
            ['key' => 'razorpay_key', 'value' => '', 'type' => 'encrypted', 'description' => 'Razorpay API Key', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'razorpay_secret', 'value' => '', 'type' => 'encrypted', 'description' => 'Razorpay API Secret', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
