<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('savings_schemes', function (Blueprint $table) {
            $table->enum('savings_type', ['RD', 'FD', 'MIS'])->after('partner_id');
            $table->enum('compounding_frequency', ['monthly', 'quarterly', 'yearly'])->default('monthly')->after('interest_type');
            $table->decimal('installment_amount', 15, 2)->nullable()->after('max_amount')->comment('For RD schemes - fixed monthly deposit');
            
            // Update interest_type to match financial standards
            $table->dropColumn('interest_type');
        });
        
        Schema::table('savings_schemes', function (Blueprint $table) {
            $table->enum('interest_type', ['simple', 'compound'])->default('compound')->after('interest_rate');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('savings_schemes', function (Blueprint $table) {
            $table->dropColumn(['savings_type', 'compounding_frequency', 'installment_amount']);
            $table->dropColumn('interest_type');
        });
        
        Schema::table('savings_schemes', function (Blueprint $table) {
            $table->enum('interest_type', ['flat', 'percentage'])->default('percentage')->after('interest_rate');
        });
    }
};
