@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<div class="page-header">
    <h1 class="page-title">Dashboard</h1>
    <div class="page-breadcrumb">
        <i class="bi bi-house"></i>
        <span>Dashboard</span>
    </div>
</div>

<!-- Welcome Card -->
<div class="row mb-4 dashboard-row">
    <div class="col-lg-8">
        <div class="card h-100" style="background: linear-gradient(135deg, #7367f0 0%, #9e95f5 100%); border: none;">
            <div class="card-body d-flex flex-column">
                <div class="row flex-grow-1 align-items-center">
                    <div class="col-md-8">
                        <h3 class="text-white mb-2">Welcome {{ auth()->user()->name }}! 👋</h3>
                        <p class="text-white opacity-75 mb-3">Manage and monitor all partners in the micro-loan system</p>
                        <h2 class="text-white mb-3">{{ $stats['total_partners'] }}</h2>
                        <p class="text-white opacity-75 small mb-3">Total Partners Registered</p>
                        <a href="{{ route('admin.partners.index') }}" class="btn btn-light">
                            <i class="bi bi-eye me-2"></i>View All Partners
                        </a>
                    </div>
                    <div class="col-md-4 text-center d-none d-md-block">
                        <div style="font-size: 120px;">👥</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card h-100">
            <div class="card-body text-center d-flex flex-column justify-content-center">
                <div class="mb-3">
                    <i class="bi bi-people" style="font-size: 60px; color: var(--primary);"></i>
                </div>
                <h4 class="mb-2" style="color: var(--text-heading); font-size: 32px; font-weight: 700;">{{ $stats['total_partners'] }}</h4>
                <p class="mb-0" style="color: var(--text-secondary); font-weight: 500;">Total Partners</p>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-lg-4 col-sm-6 mb-3">
        <div class="stat-card">
            <div class="stat-info">
                <div class="stat-label">Total Partners</div>
                <div class="stat-value">{{ number_format($stats['total_partners']) }}</div>
            </div>
            <div class="stat-icon" style="background: rgba(115, 103, 240, 0.1); color: var(--primary);">
                <i class="bi bi-people"></i>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4 col-sm-6 mb-3">
        <div class="stat-card">
            <div class="stat-info">
                <div class="stat-label">Active Partners</div>
                <div class="stat-value">{{ number_format($stats['active_partners']) }}</div>
            </div>
            <div class="stat-icon" style="background: rgba(40, 199, 111, 0.1); color: var(--success);">
                <i class="bi bi-check-circle"></i>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4 col-sm-6 mb-3">
        <div class="stat-card">
            <div class="stat-info">
                <div class="stat-label">Inactive Partners</div>
                <div class="stat-value">{{ number_format($stats['inactive_partners']) }}</div>
            </div>
            <div class="stat-icon" style="background: rgba(234, 84, 85, 0.1); color: var(--danger);">
                <i class="bi bi-x-circle"></i>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row">
    <!-- Partner Status Chart -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Partner Status</h5>
            </div>
            <div class="card-body">
                <div id="partnerStatusChart"></div>
                <div class="mt-4">
                    @php
                        $total = $stats['total_partners'];
                        $statusColors = [
                            'active' => ['color' => '#28c76f', 'label' => 'Active'],
                            'inactive' => ['color' => '#ea5455', 'label' => 'Inactive'],
                        ];
                    @endphp
                    @foreach($statusColors as $status => $info)
                        @php
                            $count = $partnerStatusData[$status] ?? 0;
                            $percentage = $total > 0 ? round(($count / $total) * 100) : 0;
                        @endphp
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center">
                                <div style="width: 12px; height: 12px; border-radius: 50%; background: {{ $info['color'] }}; margin-right: 12px;"></div>
                                <span>{{ $info['label'] }}</span>
                            </div>
                            <strong style="color: var(--text-heading);">{{ $percentage }}% ({{ $count }})</strong>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Partners -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Recent Partners</h5>
                <a href="{{ route('admin.partners.index') }}" class="btn btn-sm btn-primary">View All</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Partner Name</th>
                                <th>Company</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Status</th>
                                <th>Registered</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($recentPartners as $partner)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="user-avatar me-2" style="width: 32px; height: 32px; font-size: 12px;">
                                            {{ substr($partner->name, 0, 1) }}
                                        </div>
                                        <span>{{ $partner->name }}</span>
                                    </div>
                                </td>
                                <td>{{ $partner->company_name ?? 'N/A' }}</td>
                                <td>{{ $partner->email }}</td>
                                <td>{{ $partner->phone ?? 'N/A' }}</td>
                                <td>
                                    <span class="badge bg-{{ $partner->status === 'active' ? 'success' : 'danger' }}">
                                        {{ ucfirst($partner->status) }}
                                    </span>
                                </td>
                                <td>{{ $partner->created_at->format('d M Y') }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center py-4">
                                    <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                                    <p class="mt-2 mb-0" style="color: var(--text-secondary);">No partners yet</p>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    // Partner Status Donut Chart
    var partnerStatusOptions = {
        series: [
            {{ $partnerStatusData['active'] ?? 0 }},
            {{ $partnerStatusData['inactive'] ?? 0 }}
        ],
        chart: {
            type: 'donut',
            height: 280,
            background: 'transparent'
        },
        labels: ['Active', 'Inactive'],
        colors: ['#28c76f', '#ea5455'],
        dataLabels: {
            enabled: false
        },
        legend: {
            show: false
        },
        plotOptions: {
            pie: {
                donut: {
                    size: '75%',
                    labels: {
                        show: true,
                        name: {
                            show: true,
                            fontSize: '14px',
                            color: '#b4b7bd'
                        },
                        value: {
                            show: true,
                            fontSize: '24px',
                            fontWeight: 700,
                            color: '#fff'
                        },
                        total: {
                            show: true,
                            label: 'Total Partners',
                            fontSize: '14px',
                            color: '#b4b7bd',
                            formatter: function (w) {
                                return w.globals.seriesTotals.reduce((a, b) => a + b, 0)
                            }
                        }
                    }
                }
            }
        },
        stroke: {
            width: 0
        }
    };

    var partnerStatusChart = new ApexCharts(document.querySelector("#partnerStatusChart"), partnerStatusOptions);
    partnerStatusChart.render();
</script>
@endsection
