@extends('layouts.app')

@section('title', 'Partner Subscriptions')
@section('page-title', 'Partner Subscriptions')

@section('content')
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Subscriptions</h6>
                <h3 style="color: var(--text-heading);">{{ $stats['total_subscriptions'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Active</h6>
                <h3 style="color: var(--success);">{{ $stats['active_subscriptions'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Revenue</h6>
                <h3 style="color: var(--text-heading);">₹{{ number_format($stats['total_revenue'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">This Month</h6>
                <h3 style="color: var(--primary);">₹{{ number_format($stats['monthly_revenue'], 2) }}</h3>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.subscriptions.index') }}" class="row g-3">
            <div class="col-md-2">
                <label class="form-label">Partner</label>
                <select name="partner_id" class="form-select">
                    <option value="">All Partners</option>
                    @foreach($partners as $partner)
                        <option value="{{ $partner->id }}" {{ request('partner_id') == $partner->id ? 'selected' : '' }}>
                            {{ $partner->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                    <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                    <option value="expired" {{ request('status') === 'expired' ? 'selected' : '' }}>Expired</option>
                    <option value="cancelled" {{ request('status') === 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Plan Type</label>
                <select name="plan_type" class="form-select">
                    <option value="">All Plans</option>
                    <option value="monthly" {{ request('plan_type') === 'monthly' ? 'selected' : '' }}>Monthly</option>
                    <option value="yearly" {{ request('plan_type') === 'yearly' ? 'selected' : '' }}>Yearly</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
            </div>
            <div class="col-md-2 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('admin.subscriptions.index') }}" class="btn btn-secondary">Reset</a>
            </div>
        </form>
    </div>
</div>

<!-- Subscriptions Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Subscriptions</h5>
        <div>
            <a href="{{ route('admin.subscriptions.revenue') }}" class="btn btn-info btn-sm me-2">
                <i class="bi bi-cash-stack me-2"></i>Revenue Report
            </a>
            <a href="{{ route('admin.subscriptions.upcoming-renewals') }}" class="btn btn-warning btn-sm me-2">
                <i class="bi bi-calendar-event me-2"></i>Upcoming Renewals
            </a>
            <a href="{{ route('admin.subscriptions.create') }}" class="btn btn-primary btn-sm">
                <i class="bi bi-plus-circle me-2"></i>Add Subscription
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Partner</th>
                        <th>Plan</th>
                        <th class="text-end">Amount</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Payment Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subscriptions as $subscription)
                    <tr>
                        <td>
                            <strong>{{ $subscription->partner->name }}</strong>
                            @if($subscription->partner->company_name)
                                <br><small class="text-muted">{{ $subscription->partner->company_name }}</small>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $subscription->plan_type === 'yearly' ? 'warning' : 'primary' }}">
                                {{ ucfirst($subscription->plan_type) }}
                            </span>
                        </td>
                        <td class="text-end">₹{{ number_format($subscription->amount, 2) }}</td>
                        <td>{{ $subscription->start_date ? $subscription->start_date->format('d M Y') : 'N/A' }}</td>
                        <td>
                            {{ $subscription->end_date ? $subscription->end_date->format('d M Y') : 'N/A' }}
                            @if($subscription->end_date && $subscription->end_date->isFuture())
                                <br><small class="text-muted">
                                    {{ now()->diffInDays($subscription->end_date) }} days left
                                </small>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $subscription->status === 'active' ? 'success' : ($subscription->status === 'pending' ? 'warning' : 'secondary') }}">
                                {{ ucfirst($subscription->status) }}
                            </span>
                        </td>
                        <td>{{ $subscription->paid_at ? $subscription->paid_at->format('d M Y') : 'N/A' }}</td>
                        <td>
                            <div class="btn-group">
                                <a href="{{ route('admin.subscriptions.show', $subscription) }}" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <button type="button" class="btn btn-sm btn-{{ $subscription->status === 'active' ? 'warning' : 'success' }}" 
                                        onclick="updateStatus({{ $subscription->id }}, '{{ $subscription->status === 'active' ? 'cancelled' : 'active' }}')"
                                        title="{{ $subscription->status === 'active' ? 'Deactivate' : 'Activate' }}">
                                    <i class="bi bi-{{ $subscription->status === 'active' ? 'x-circle' : 'check-circle' }}"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No subscriptions found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $subscriptions->links() }}
        </div>
    </div>
</div>

<!-- Status Update Form (Hidden) -->
<form id="statusForm" method="POST" style="display: none;">
    @csrf
    @method('PUT')
    <input type="hidden" name="status" id="statusInput">
</form>

@push('scripts')
<script>
    function updateStatus(subscriptionId, newStatus) {
        if (confirm(`Are you sure you want to ${newStatus === 'active' ? 'activate' : 'deactivate'} this subscription?`)) {
            const form = document.getElementById('statusForm');
            form.action = `/admin/subscriptions/${subscriptionId}/status`;
            document.getElementById('statusInput').value = newStatus;
            form.submit();
        }
    }
</script>
@endpush
@endsection


