@extends('layouts.app')

@section('title', 'Revenue Report')
@section('page-title', 'Revenue Report')

@section('content')
<!-- Summary Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Revenue</h6>
                <h3 style="color: var(--text-heading);">₹{{ number_format($summary['total_revenue'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Subscriptions</h6>
                <h3 style="color: var(--text-heading);">{{ $summary['total_subscriptions'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">This Month</h6>
                <h3 style="color: var(--success);">₹{{ number_format($summary['this_month'], 2) }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Monthly Average</h6>
                <h3 style="color: var(--primary);">₹{{ number_format($summary['monthly_avg'], 2) }}</h3>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.subscriptions.revenue') }}" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
            </div>
            <div class="col-md-4">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('admin.subscriptions.revenue') }}" class="btn btn-secondary">Reset</a>
            </div>
        </form>
    </div>
</div>

<!-- Revenue by Plan Type -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Revenue by Plan Type</h5>
            </div>
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Plan Type</th>
                            <th class="text-end">Count</th>
                            <th class="text-end">Total Revenue</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($revenueByPlan as $planType => $data)
                        <tr>
                            <td><strong>{{ ucfirst($planType) }}</strong></td>
                            <td class="text-end">{{ $data['count'] }}</td>
                            <td class="text-end">₹{{ number_format($data['total'], 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Monthly Revenue Breakdown</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Month</th>
                                <th class="text-end">Count</th>
                                <th class="text-end">Revenue</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($monthlyRevenue as $month => $data)
                            <tr>
                                <td>{{ $data['month'] }}</td>
                                <td class="text-end">{{ $data['count'] }}</td>
                                <td class="text-end">₹{{ number_format($data['total'], 2) }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="3" class="text-center text-muted">No data available</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Detailed Transactions -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Revenue Transactions</h5>
        <a href="{{ route('admin.subscriptions.index') }}" class="btn btn-secondary btn-sm">Back to Subscriptions</a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Partner</th>
                        <th>Plan</th>
                        <th class="text-end">Amount</th>
                        <th>Payment Date</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subscriptions as $subscription)
                    <tr>
                        <td>{{ $subscription->partner->name }}</td>
                        <td>
                            <span class="badge bg-{{ $subscription->plan_type === 'yearly' ? 'warning' : 'primary' }}">
                                {{ ucfirst($subscription->plan_type) }}
                            </span>
                        </td>
                        <td class="text-end">₹{{ number_format($subscription->amount, 2) }}</td>
                        <td>{{ $subscription->paid_at ? $subscription->paid_at->format('d M Y') : 'N/A' }}</td>
                        <td>
                            <span class="badge bg-success">Active</span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No revenue data found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
                @if($subscriptions->count() > 0)
                <tfoot>
                    <tr class="table-info">
                        <td colspan="2" class="text-end"><strong>Total:</strong></td>
                        <td class="text-end"><strong>₹{{ number_format($subscriptions->sum('amount'), 2) }}</strong></td>
                        <td colspan="2"></td>
                    </tr>
                </tfoot>
                @endif
            </table>
        </div>
    </div>
</div>
@endsection


