@extends('layouts.app')

@section('title', 'Subscription Details')
@section('page-title', 'Subscription Details')

@section('content')
<div class="card mb-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Subscription Information</h5>
        <div>
            <form action="{{ route('admin.subscriptions.update-status', $subscription) }}" method="POST" class="d-inline">
                @csrf
                @method('PUT')
                <input type="hidden" name="status" value="{{ $subscription->status === 'active' ? 'cancelled' : 'active' }}">
                <button type="submit" class="btn btn-{{ $subscription->status === 'active' ? 'warning' : 'success' }} btn-sm me-2"
                        onclick="return confirm('Are you sure you want to {{ $subscription->status === 'active' ? 'deactivate' : 'activate' }} this subscription?');">
                    <i class="bi bi-{{ $subscription->status === 'active' ? 'x-circle' : 'check-circle' }} me-2"></i>
                    {{ $subscription->status === 'active' ? 'Deactivate' : 'Activate' }}
                </button>
            </form>
            <a href="{{ route('admin.subscriptions.index') }}" class="btn btn-secondary btn-sm">Back</a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <h6>Partner Information</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Partner Name:</th>
                        <td>{{ $subscription->partner->name }}</td>
                    </tr>
                    <tr>
                        <th>Company:</th>
                        <td>{{ $subscription->partner->company_name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Email:</th>
                        <td>{{ $subscription->partner->email }}</td>
                    </tr>
                    <tr>
                        <th>Phone:</th>
                        <td>{{ $subscription->partner->phone ?? 'N/A' }}</td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <h6>Subscription Details</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Plan Type:</th>
                        <td>
                            <span class="badge bg-{{ $subscription->plan_type === 'yearly' ? 'warning' : 'primary' }}">
                                {{ ucfirst($subscription->plan_type) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Amount:</th>
                        <td><strong>₹{{ number_format($subscription->amount, 2) }}</strong></td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <span class="badge bg-{{ $subscription->status === 'active' ? 'success' : ($subscription->status === 'pending' ? 'warning' : 'secondary') }}">
                                {{ ucfirst($subscription->status) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th>Start Date:</th>
                        <td>{{ $subscription->start_date ? $subscription->start_date->format('d M Y') : 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>End Date:</th>
                        <td>
                            {{ $subscription->end_date ? $subscription->end_date->format('d M Y') : 'N/A' }}
                            @if($subscription->end_date && $subscription->end_date->isFuture())
                                <br><small class="text-muted">
                                    {{ now()->diffInDays($subscription->end_date) }} days remaining
                                </small>
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <th>Payment Date:</th>
                        <td>{{ $subscription->paid_at ? $subscription->paid_at->format('d M Y H:i') : 'N/A' }}</td>
                    </tr>
                </table>
            </div>
        </div>
        
        @if($subscription->razorpay_order_id || $subscription->razorpay_payment_id)
        <hr>
        <div class="row">
            <div class="col-md-12">
                <h6>Payment Information</h6>
                <table class="table table-borderless">
                    @if($subscription->razorpay_order_id)
                    <tr>
                        <th width="20%">Razorpay Order ID:</th>
                        <td><code>{{ $subscription->razorpay_order_id }}</code></td>
                    </tr>
                    @endif
                    @if($subscription->razorpay_payment_id)
                    <tr>
                        <th>Razorpay Payment ID:</th>
                        <td><code>{{ $subscription->razorpay_payment_id }}</code></td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection


