@extends('layouts.app')

@section('title', 'Upcoming Renewals')
@section('page-title', 'Upcoming Renewals')

@section('content')
<!-- Summary Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Upcoming</h6>
                <h3 style="color: var(--text-heading);">{{ $summary['total_upcoming'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Within 7 Days</h6>
                <h3 style="color: var(--danger);">{{ $summary['within_7_days'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Within 15 Days</h6>
                <h3 style="color: var(--warning);">{{ $summary['within_15_days'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Expected Revenue</h6>
                <h3 style="color: var(--success);">₹{{ number_format($summary['expected_revenue'], 2) }}</h3>
            </div>
        </div>
    </div>
</div>

<!-- Filter -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.subscriptions.upcoming-renewals') }}" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Show Renewals Within (Days)</label>
                <input type="number" name="days" class="form-control" value="{{ $days }}" min="1" max="365">
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('admin.subscriptions.upcoming-renewals') }}" class="btn btn-secondary">Reset</a>
            </div>
        </form>
    </div>
</div>

<!-- Upcoming Renewals Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Upcoming Renewals (Next {{ $days }} Days)</h5>
        <a href="{{ route('admin.subscriptions.index') }}" class="btn btn-secondary btn-sm">Back to Subscriptions</a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Partner</th>
                        <th>Plan</th>
                        <th class="text-end">Amount</th>
                        <th>End Date</th>
                        <th class="text-end">Days Until Renewal</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subscriptions as $subscription)
                    @php
                        $daysUntil = now()->diffInDays($subscription->end_date, false);
                    @endphp
                    <tr class="{{ $daysUntil <= 7 ? 'table-danger' : ($daysUntil <= 15 ? 'table-warning' : '') }}">
                        <td>
                            <strong>{{ $subscription->partner->name }}</strong>
                            @if($subscription->partner->company_name)
                                <br><small class="text-muted">{{ $subscription->partner->company_name }}</small>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $subscription->plan_type === 'yearly' ? 'warning' : 'primary' }}">
                                {{ ucfirst($subscription->plan_type) }}
                            </span>
                        </td>
                        <td class="text-end">₹{{ number_format($subscription->amount, 2) }}</td>
                        <td>{{ $subscription->end_date->format('d M Y') }}</td>
                        <td class="text-end">
                            <span class="badge bg-{{ $daysUntil <= 7 ? 'danger' : ($daysUntil <= 15 ? 'warning' : 'info') }}">
                                {{ $daysUntil }} days
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-success">Active</span>
                        </td>
                        <td>
                            <a href="{{ route('admin.subscriptions.show', $subscription) }}" class="btn btn-sm btn-info" title="View">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <i class="bi bi-check-circle" style="font-size: 2rem; color: var(--success);"></i>
                            <p class="text-muted mt-2 mb-0">No upcoming renewals in the next {{ $days }} days</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection


