@extends('layouts.app')

@section('title', 'Customer Details')
@section('page-title', 'Customer Details')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Customer Information</h5>
        <div>
            <a href="{{ route('partner.customers.edit', $customer) }}" class="btn btn-warning btn-sm">
                <i class="bi bi-pencil"></i> Edit
            </a>
            <a href="{{ route('partner.customers.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Back
            </a>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-2 mb-3">
                @if($customer->photo)
                    <img src="{{ Storage::url($customer->photo) }}" alt="{{ $customer->name }}" 
                         class="img-fluid rounded" style="width: 150px; height: 150px; object-fit: cover; border: 2px solid var(--border-color);">
                @else
                    <div class="bg-secondary rounded d-flex align-items-center justify-content-center" 
                         style="width: 150px; height: 150px; border: 2px solid var(--border-color);">
                        <i class="bi bi-person-circle" style="font-size: 80px; color: var(--text-secondary);"></i>
                    </div>
                @endif
            </div>
            <div class="col-md-5">
                <p><strong>Customer Code:</strong> {{ $customer->customer_code }}</p>
                <p><strong>Name:</strong> {{ $customer->name }}</p>
                <p><strong>Phone:</strong> {{ $customer->phone }}</p>
                <p><strong>Email:</strong> {{ $customer->email ?? 'N/A' }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>Status:</strong> 
                    <span class="badge bg-{{ $customer->status === 'active' ? 'success' : 'secondary' }}">
                        {{ ucfirst($customer->status) }}
                    </span>
                </p>
                <p><strong>Date of Birth:</strong> {{ $customer->date_of_birth?->format('d M Y') ?? 'N/A' }}</p>
                <p><strong>Gender:</strong> {{ ucfirst($customer->gender ?? 'N/A') }}</p>
                <p><strong>Address:</strong> {{ $customer->address ?? 'N/A' }}</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card stat-card">
            <div class="card-body">
                <h5>Total Loans</h5>
                <h2>{{ $customer->loans->count() }}</h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card stat-card success">
            <div class="card-body">
                <h5>Total Savings</h5>
                <h2>{{ $customer->savings->count() }}</h2>
                @if($customer->savings->count() > 0)
                <a href="{{ route('partner.savings.statement', $customer) }}" class="btn btn-sm btn-outline-light mt-2" target="_blank">
                    <i class="bi bi-file-earmark-text"></i> View Statement
                </a>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card stat-card info">
            <div class="card-body">
                <h5>Total Repayments</h5>
                <h2>{{ $customer->repayments->count() }}</h2>
            </div>
        </div>
    </div>
</div>
@endsection

