@extends('layouts.app')

@section('title', 'Edit Loan Scheme')
@section('page-title', 'Edit Loan Scheme')

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Edit Loan Scheme</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('partner.loan-schemes.update', $loanScheme) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="name" class="form-label">Scheme Name *</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $loanScheme->name) }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="status" class="form-label">Status *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="active" {{ old('status', $loanScheme->status) === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ old('status', $loanScheme->status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
            </div>
            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $loanScheme->description) }}</textarea>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="interest_type" class="form-label">Interest Type *</label>
                    <select class="form-select" id="interest_type" name="interest_type" required>
                        <option value="percentage" {{ old('interest_type', $loanScheme->interest_type) === 'percentage' ? 'selected' : '' }}>Percentage (%)</option>
                        <option value="flat" {{ old('interest_type', $loanScheme->interest_type) === 'flat' ? 'selected' : '' }}>Flat Amount</option>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="interest_rate" class="form-label">Interest Rate/Amount *</label>
                    <input type="number" step="0.01" class="form-control @error('interest_rate') is-invalid @enderror" 
                           id="interest_rate" name="interest_rate" value="{{ old('interest_rate', $loanScheme->interest_rate) }}" required>
                    @error('interest_rate')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="duration_type" class="form-label">Duration Type *</label>
                    <select class="form-select" id="duration_type" name="duration_type" required>
                        <option value="daily" {{ old('duration_type', $loanScheme->duration_type) === 'daily' ? 'selected' : '' }}>Daily</option>
                        <option value="weekly" {{ old('duration_type', $loanScheme->duration_type) === 'weekly' ? 'selected' : '' }}>Weekly</option>
                        <option value="monthly" {{ old('duration_type', $loanScheme->duration_type) === 'monthly' ? 'selected' : '' }}>Monthly</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="duration_value" class="form-label">Duration Value *</label>
                    <input type="number" class="form-control" id="duration_value" name="duration_value" 
                           value="{{ old('duration_value', $loanScheme->duration_value) }}" required>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="min_amount" class="form-label">Min Amount *</label>
                    <input type="number" step="0.01" class="form-control @error('min_amount') is-invalid @enderror" 
                           id="min_amount" name="min_amount" value="{{ old('min_amount', $loanScheme->min_amount) }}" required>
                    @error('min_amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="max_amount" class="form-label">Max Amount</label>
                    <input type="number" step="0.01" class="form-control" id="max_amount" name="max_amount" value="{{ old('max_amount', $loanScheme->max_amount) }}">
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="processing_fee" class="form-label">Processing Fee</label>
                    <input type="number" step="0.01" class="form-control" id="processing_fee" name="processing_fee" value="{{ old('processing_fee', $loanScheme->processing_fee) }}" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label for="insurance_fee" class="form-label">Insurance Fee</label>
                    <input type="number" step="0.01" class="form-control" id="insurance_fee" name="insurance_fee" value="{{ old('insurance_fee', $loanScheme->insurance_fee) }}" min="0">
                </div>
                <div class="col-md-4 mb-3">
                    <label for="other_fee" class="form-label">Other Fee</label>
                    <input type="number" step="0.01" class="form-control" id="other_fee" name="other_fee" value="{{ old('other_fee', $loanScheme->other_fee) }}" min="0">
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="late_fee_type" class="form-label">Late Fee Type</label>
                    <select class="form-select" id="late_fee_type" name="late_fee_type">
                        <option value="">No Late Fee</option>
                        <option value="percentage" {{ old('late_fee_type', $loanScheme->late_fee_type) === 'percentage' ? 'selected' : '' }}>Percentage (%)</option>
                        <option value="fixed" {{ old('late_fee_type', $loanScheme->late_fee_type) === 'fixed' ? 'selected' : '' }}>Fixed Amount</option>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="late_fee_value" class="form-label">Late Fee Value</label>
                    <input type="number" step="0.01" class="form-control" id="late_fee_value" name="late_fee_value" 
                           value="{{ old('late_fee_value', $loanScheme->late_fee_value) }}" min="0">
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Update Loan Scheme
                </button>
                <a href="{{ route('partner.loan-schemes.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
@endsection


