@extends('layouts.app')

@section('title', 'Loan Scheme Details')
@section('page-title', 'Loan Scheme Details')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">{{ $loanScheme->name }}</h5>
        <div>
            <a href="{{ route('partner.loan-schemes.edit', $loanScheme) }}" class="btn btn-warning">
                <i class="bi bi-pencil"></i> Edit
            </a>
            <a href="{{ route('partner.loan-schemes.index') }}" class="btn btn-secondary">Back</a>
        </div>
    </div>
    <div class="card-body">
        <div class="row mb-4">
            <div class="col-md-6">
                <h6>Basic Information</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Name:</th>
                        <td>{{ $loanScheme->name }}</td>
                    </tr>
                    <tr>
                        <th>Description:</th>
                        <td>{{ $loanScheme->description ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>
                            <span class="badge bg-{{ $loanScheme->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($loanScheme->status) }}
                            </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <h6>Interest Details</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Interest Type:</th>
                        <td>{{ ucfirst($loanScheme->interest_type) }}</td>
                    </tr>
                    <tr>
                        <th>Interest Rate:</th>
                        <td>{{ $loanScheme->interest_rate }}%</td>
                    </tr>
                    <tr>
                        <th>Duration:</th>
                        <td>{{ $loanScheme->duration_value }} {{ ucfirst($loanScheme->duration_type) }}</td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="row mb-4">
            <div class="col-md-6">
                <h6>Amount Limits</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Min Amount:</th>
                        <td>₹{{ number_format($loanScheme->min_amount, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Max Amount:</th>
                        <td>₹{{ number_format($loanScheme->max_amount ?? 0, 2) }}</td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <h6>Fees</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Processing Fee:</th>
                        <td>₹{{ number_format($loanScheme->processing_fee, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Insurance Fee:</th>
                        <td>₹{{ number_format($loanScheme->insurance_fee, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Other Fee:</th>
                        <td>₹{{ number_format($loanScheme->other_fee, 2) }}</td>
                    </tr>
                </table>
            </div>
        </div>
        @if($loanScheme->late_fee_type)
        <div class="row">
            <div class="col-md-6">
                <h6>Late Fee</h6>
                <table class="table table-borderless">
                    <tr>
                        <th width="40%">Late Fee Type:</th>
                        <td>{{ ucfirst($loanScheme->late_fee_type) }}</td>
                    </tr>
                    <tr>
                        <th>Late Fee Value:</th>
                        <td>{{ $loanScheme->late_fee_value }}</td>
                    </tr>
                </table>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection


