@php
use Illuminate\Support\Facades\Storage;
@endphp
@extends('layouts.app')

@section('title', 'No Objection Certificate')
@section('page-title', 'No Objection Certificate')

@section('content')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        body {
            background: white !important;
        }
        .document-container {
            box-shadow: none !important;
            border: none !important;
        }
    }
    
    .document-container {
        max-width: 210mm;
        margin: 0 auto;
        background: white;
        padding: 2rem;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }
    
    .letterhead {
        border-bottom: 3px solid #6366f1;
        padding-bottom: 1.5rem;
        margin-bottom: 2rem;
    }
    
    .letterhead-logo {
        max-height: 80px;
        max-width: 200px;
        object-fit: contain;
    }
    
    .company-name {
        font-size: 1.5rem;
        font-weight: 700;
        color: #1e293b;
        margin: 0.5rem 0;
    }
    
    .company-details {
        font-size: 0.9rem;
        color: #64748b;
        line-height: 1.6;
    }
    
    .document-title {
        text-align: center;
        font-size: 1.5rem;
        font-weight: 700;
        color: #1e293b;
        margin: 2rem 0;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .document-body {
        line-height: 1.8;
        font-size: 1rem;
        color: #334155;
    }
    
    .document-section {
        margin: 1.5rem 0;
    }
    
    .signature-section {
        margin-top: 3rem;
        display: flex;
        justify-content: space-between;
    }
    
    .signature-box {
        width: 45%;
        text-align: center;
    }
    
    .signature-line {
        border-top: 2px solid #1e293b;
        margin-top: 3rem;
        padding-top: 0.5rem;
    }
    
    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin: 1rem 0;
    }
    
    .info-table td {
        padding: 0.5rem;
        border-bottom: 1px solid #e2e8f0;
    }
    
    .info-table td:first-child {
        font-weight: 600;
        width: 40%;
        color: #475569;
    }
    
    .stamp-section {
        margin-top: 2rem;
        text-align: right;
    }
    
    .stamp-box {
        display: inline-block;
        border: 2px dashed #6366f1;
        padding: 1rem 2rem;
        text-align: center;
    }
</style>

<div class="no-print mb-3">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">No Objection Certificate (NOC)</h5>
                <div class="d-flex gap-2">
                    <button onclick="window.print()" class="btn btn-primary btn-sm">
                        <i class="bi bi-printer"></i> Print
                    </button>
                    <a href="{{ route('partner.loans.show', $loan) }}" class="btn btn-secondary btn-sm">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="document-container">
    <!-- Letterhead -->
    <div class="letterhead">
        <div class="row align-items-center">
            <div class="col-md-3 text-center">
                @if($loan->partner->logo)
                    <img src="{{ Storage::url($loan->partner->logo) }}" alt="Company Logo" class="letterhead-logo">
                @else
                    <div class="bg-light rounded d-flex align-items-center justify-content-center mx-auto" style="height: 80px; width: 150px;">
                        <i class="bi bi-building text-muted" style="font-size: 2.5rem;"></i>
                    </div>
                @endif
            </div>
            <div class="col-md-9">
                <div class="company-name">{{ $loan->partner->company_name ?? $loan->partner->name }}</div>
                <div class="company-details">
                    @if($loan->partner->address)
                        <i class="bi bi-geo-alt"></i> {{ $loan->partner->address }}<br>
                    @endif
                    @if($loan->partner->phone)
                        <i class="bi bi-telephone"></i> {{ $loan->partner->phone }}
                    @endif
                    @if($loan->partner->whatsapp)
                        | <i class="bi bi-whatsapp"></i> {{ $loan->partner->whatsapp }}
                    @endif
                    @if($loan->partner->email)
                        <br><i class="bi bi-envelope"></i> {{ $loan->partner->email }}
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Document Title -->
    <div class="document-title">No Objection Certificate</div>

    <!-- Document Body -->
    <div class="document-body">
        <div class="document-section">
            <p><strong>Date:</strong> {{ now()->format('d F Y') }}</p>
            <p><strong>Certificate No:</strong> NOC-{{ $loan->loan_number }}</p>
        </div>

        <div class="document-section">
            <p><strong>To Whom It May Concern,</strong></p>
        </div>

        <div class="document-section">
            <p>This is to certify that <strong>{{ $loan->customer->name }}</strong> (Customer Code: {{ $loan->customer->customer_code }}) has availed a loan facility from our organization with the following details:</p>
        </div>

        <div class="document-section">
            <table class="info-table">
                <tr>
                    <td>Loan Number:</td>
                    <td><strong>{{ $loan->loan_number }}</strong></td>
                </tr>
                <tr>
                    <td>Loan Amount:</td>
                    <td><strong>₹{{ number_format($loan->total_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td>Principal Amount:</td>
                    <td>₹{{ number_format($loan->principal_amount, 2) }}</td>
                </tr>
                <tr>
                    <td>Disbursement Date:</td>
                    <td>{{ $loan->disbursement_date->format('d F Y') }}</td>
                </tr>
                <tr>
                    <td>Maturity Date:</td>
                    <td>{{ $loan->maturity_date->format('d F Y') }}</td>
                </tr>
                <tr>
                    <td>Loan Status:</td>
                    <td>
                        <strong>{{ ucfirst($loan->status) }}</strong>
                        @if($loan->status === 'active')
                            - Outstanding Amount: ₹{{ number_format($loan->remaining_amount, 2) }}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td>Paid Amount:</td>
                    <td>₹{{ number_format($loan->paid_amount, 2) }}</td>
                </tr>
                <tr>
                    <td>Remaining Amount:</td>
                    <td><strong>₹{{ number_format($loan->remaining_amount, 2) }}</strong></td>
                </tr>
            </table>
        </div>

        <div class="document-section">
            <p>We have <strong>NO OBJECTION</strong> if the above-mentioned customer wishes to:</p>
            <ul>
                <li>Avail any other financial facility from other institutions</li>
                <li>Transfer or close the account with us</li>
                <li>Undertake any other financial transactions</li>
            </ul>
        </div>

        <div class="document-section">
            <p>This certificate is issued at the request of the customer and is valid for the purpose stated above.</p>
            
            <p>This certificate is issued without any liability on our part and is subject to the customer clearing all outstanding dues, if any.</p>
        </div>

        <div class="document-section">
            <p>For <strong>{{ $loan->partner->company_name ?? $loan->partner->name }}</strong></p>
        </div>

        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line">
                    <strong>{{ $loan->partner->company_name ?? $loan->partner->name }}</strong>
                </div>
            </div>
            <div class="signature-box">
                <div class="signature-line">
                    <strong>Authorized Signatory</strong>
                </div>
            </div>
        </div>

        <div class="stamp-section">
            <div class="stamp-box">
                <strong>STAMP</strong><br>
                <small>{{ now()->format('d M Y') }}</small>
            </div>
        </div>
    </div>
</div>
@endsection

