@php
use Illuminate\Support\Facades\Storage;
@endphp
@extends('layouts.app')

@section('title', 'Repayment Receipt')
@section('page-title', 'Repayment Receipt')

@section('content')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        body {
            background: white !important;
        }
        .document-container {
            box-shadow: none !important;
            border: none !important;
        }
        .page-break {
            page-break-after: always;
        }
    }
    
    .document-container {
        max-width: 210mm;
        margin: 0 auto;
        background: white;
        padding: 2rem;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }
    
    .receipt-header {
        border: 3px solid #6366f1;
        padding: 1.5rem;
        margin-bottom: 2rem;
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
    }
    
    .receipt-logo {
        max-height: 60px;
        max-width: 150px;
        object-fit: contain;
    }
    
    .company-name {
        font-size: 1.25rem;
        font-weight: 700;
        color: #1e293b;
        margin: 0.5rem 0;
    }
    
    .company-details {
        font-size: 0.85rem;
        color: #64748b;
        line-height: 1.5;
    }
    
    .receipt-title {
        text-align: center;
        font-size: 1.75rem;
        font-weight: 700;
        color: #1e293b;
        margin: 1.5rem 0;
        text-transform: uppercase;
        letter-spacing: 2px;
        border-bottom: 2px solid #6366f1;
        padding-bottom: 0.5rem;
    }
    
    .receipt-number {
        text-align: center;
        font-size: 1.1rem;
        color: #475569;
        margin-bottom: 2rem;
    }
    
    .receipt-body {
        line-height: 1.8;
        font-size: 1rem;
        color: #334155;
    }
    
    .receipt-section {
        margin: 1.5rem 0;
        padding: 1rem;
        background: #f8fafc;
        border-left: 4px solid #6366f1;
    }
    
    .amount-box {
        background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
        color: white;
        padding: 1.5rem;
        border-radius: 0.5rem;
        text-align: center;
        margin: 2rem 0;
    }
    
    .amount-label {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-bottom: 0.5rem;
    }
    
    .amount-value {
        font-size: 2rem;
        font-weight: 700;
    }
    
    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin: 1rem 0;
    }
    
    .info-table td {
        padding: 0.75rem;
        border-bottom: 1px solid #e2e8f0;
    }
    
    .info-table td:first-child {
        font-weight: 600;
        width: 40%;
        color: #475569;
    }
    
    .signature-section {
        margin-top: 3rem;
        display: flex;
        justify-content: space-between;
    }
    
    .signature-box {
        width: 45%;
        text-align: center;
    }
    
    .signature-line {
        border-top: 2px solid #1e293b;
        margin-top: 3rem;
        padding-top: 0.5rem;
    }
    
    .footer-note {
        margin-top: 2rem;
        padding-top: 1rem;
        border-top: 1px solid #e2e8f0;
        font-size: 0.85rem;
        color: #64748b;
        text-align: center;
    }
</style>

<div class="no-print mb-3">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Repayment Receipt</h5>
                <div class="d-flex gap-2">
                    <button onclick="window.print()" class="btn btn-primary btn-sm">
                        <i class="bi bi-printer"></i> Print
                    </button>
                    <a href="{{ route('partner.loans.show', $repayment->loan) }}" class="btn btn-secondary btn-sm">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="document-container">
    <!-- Receipt Header -->
    <div class="receipt-header">
        <div class="row align-items-center">
            <div class="col-md-3 text-center">
                @if($repayment->loan->partner->logo)
                    <img src="{{ Storage::url($repayment->loan->partner->logo) }}" alt="Company Logo" class="receipt-logo">
                @else
                    <div class="bg-white rounded d-flex align-items-center justify-content-center mx-auto" style="height: 60px; width: 120px;">
                        <i class="bi bi-building text-muted" style="font-size: 2rem;"></i>
                    </div>
                @endif
            </div>
            <div class="col-md-9">
                <div class="company-name">{{ $repayment->loan->partner->company_name ?? $repayment->loan->partner->name }}</div>
                <div class="company-details">
                    @if($repayment->loan->partner->address)
                        <i class="bi bi-geo-alt"></i> {{ $repayment->loan->partner->address }}<br>
                    @endif
                    @if($repayment->loan->partner->phone)
                        <i class="bi bi-telephone"></i> {{ $repayment->loan->partner->phone }}
                    @endif
                    @if($repayment->loan->partner->whatsapp)
                        | <i class="bi bi-whatsapp"></i> {{ $repayment->loan->partner->whatsapp }}
                    @endif
                    @if($repayment->loan->partner->email)
                        <br><i class="bi bi-envelope"></i> {{ $repayment->loan->partner->email }}
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Receipt Title -->
    <div class="receipt-title">Payment Receipt</div>
    <div class="receipt-number">
        <strong>Receipt No:</strong> {{ $repayment->repayment_number }}
    </div>

    <!-- Amount Box -->
    <div class="amount-box">
        <div class="amount-label">Amount Received</div>
        <div class="amount-value">₹{{ number_format($repayment->amount, 2) }}</div>
    </div>

    <!-- Receipt Body -->
    <div class="receipt-body">
        <div class="receipt-section">
            <h6 class="mb-3"><strong>Payment Details</strong></h6>
            <table class="info-table">
                <tr>
                    <td>Payment Date:</td>
                    <td><strong>{{ $repayment->payment_date->format('d F Y') }}</strong></td>
                </tr>
                <tr>
                    <td>Due Date:</td>
                    <td>{{ $repayment->due_date->format('d F Y') }}</td>
                </tr>
                <tr>
                    <td>Payment Method:</td>
                    <td>{{ ucfirst(str_replace('_', ' ', $repayment->payment_method)) }}</td>
                </tr>
                @if($repayment->reference_number)
                <tr>
                    <td>Reference Number:</td>
                    <td>{{ $repayment->reference_number }}</td>
                </tr>
                @endif
                <tr>
                    <td>Payment Status:</td>
                    <td>
                        <span class="badge bg-{{ $repayment->status === 'on_time' ? 'success' : 'warning' }}">
                            {{ ucfirst(str_replace('_', ' ', $repayment->status)) }}
                        </span>
                    </td>
                </tr>
            </table>
        </div>

        <div class="receipt-section">
            <h6 class="mb-3"><strong>Loan Information</strong></h6>
            <table class="info-table">
                <tr>
                    <td>Loan Number:</td>
                    <td><strong>{{ $repayment->loan->loan_number }}</strong></td>
                </tr>
                <tr>
                    <td>Customer Name:</td>
                    <td><strong>{{ $repayment->customer->name }}</strong></td>
                </tr>
                <tr>
                    <td>Customer Code:</td>
                    <td>{{ $repayment->customer->customer_code }}</td>
                </tr>
                <tr>
                    <td>Scheme:</td>
                    <td>{{ $repayment->loan->loanScheme?->name ?? $repayment->loan->scheme?->name ?? 'N/A' }}</td>
                </tr>
            </table>
        </div>

        <div class="receipt-section">
            <h6 class="mb-3"><strong>Payment Breakdown</strong></h6>
            <table class="info-table">
                <tr>
                    <td>Principal Amount:</td>
                    <td>₹{{ number_format($repayment->principal_amount, 2) }}</td>
                </tr>
                <tr>
                    <td>Interest Amount:</td>
                    <td>₹{{ number_format($repayment->interest_amount, 2) }}</td>
                </tr>
                @if($repayment->penalty_amount > 0)
                <tr>
                    <td>Penalty Amount:</td>
                    <td>₹{{ number_format($repayment->penalty_amount, 2) }}</td>
                </tr>
                @endif
                <tr style="background: #f1f5f9;">
                    <td><strong>Total Amount:</strong></td>
                    <td><strong>₹{{ number_format($repayment->amount, 2) }}</strong></td>
                </tr>
            </table>
        </div>

        @if($repayment->notes)
        <div class="receipt-section">
            <h6 class="mb-2"><strong>Notes:</strong></h6>
            <p class="mb-0">{{ $repayment->notes }}</p>
        </div>
        @endif

        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line">
                    <strong>{{ $repayment->loan->partner->company_name ?? $repayment->loan->partner->name }}</strong>
                </div>
            </div>
            <div class="signature-box">
                <div class="signature-line">
                    <strong>Authorized Signatory</strong>
                </div>
            </div>
        </div>

        <div class="footer-note">
            <p class="mb-0">This is a computer-generated receipt. No signature required.</p>
            <p class="mb-0">Generated on: {{ now()->format('d F Y, h:i A') }}</p>
        </div>
    </div>
</div>
@endsection

