@php
use Illuminate\Support\Facades\Storage;
@endphp
@extends('layouts.app')

@section('title', 'Loan Sanction Letter')
@section('page-title', 'Loan Sanction Letter')

@section('content')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        body {
            background: white !important;
        }
        .document-container {
            box-shadow: none !important;
            border: none !important;
        }
    }
    
    .document-container {
        max-width: 210mm;
        margin: 0 auto;
        background: white;
        padding: 2rem;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
    }
    
    .letterhead {
        border-bottom: 3px solid #6366f1;
        padding-bottom: 1.5rem;
        margin-bottom: 2rem;
    }
    
    .letterhead-logo {
        max-height: 80px;
        max-width: 200px;
        object-fit: contain;
    }
    
    .company-name {
        font-size: 1.5rem;
        font-weight: 700;
        color: #1e293b;
        margin: 0.5rem 0;
    }
    
    .company-details {
        font-size: 0.9rem;
        color: #64748b;
        line-height: 1.6;
    }
    
    .document-title {
        text-align: center;
        font-size: 1.5rem;
        font-weight: 700;
        color: #1e293b;
        margin: 2rem 0;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .document-body {
        line-height: 1.8;
        font-size: 1rem;
        color: #334155;
    }
    
    .document-section {
        margin: 1.5rem 0;
    }
    
    .signature-section {
        margin-top: 3rem;
        display: flex;
        justify-content: space-between;
    }
    
    .signature-box {
        width: 45%;
        text-align: center;
    }
    
    .signature-line {
        border-top: 2px solid #1e293b;
        margin-top: 3rem;
        padding-top: 0.5rem;
    }
    
    .info-table {
        width: 100%;
        border-collapse: collapse;
        margin: 1rem 0;
    }
    
    .info-table td {
        padding: 0.5rem;
        border-bottom: 1px solid #e2e8f0;
    }
    
    .info-table td:first-child {
        font-weight: 600;
        width: 40%;
        color: #475569;
    }
</style>

<div class="no-print mb-3">
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Loan Sanction Letter</h5>
                <div class="d-flex gap-2">
                    <button onclick="window.print()" class="btn btn-primary btn-sm">
                        <i class="bi bi-printer"></i> Print
                    </button>
                    <a href="{{ route('partner.loans.show', $loan) }}" class="btn btn-secondary btn-sm">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="document-container">
    <!-- Letterhead -->
    <div class="letterhead">
        <div class="row align-items-center">
            <div class="col-md-3 text-center">
                @if($loan->partner->logo)
                    <img src="{{ Storage::url($loan->partner->logo) }}" alt="Company Logo" class="letterhead-logo">
                @else
                    <div class="bg-light rounded d-flex align-items-center justify-content-center mx-auto" style="height: 80px; width: 150px;">
                        <i class="bi bi-building text-muted" style="font-size: 2.5rem;"></i>
                    </div>
                @endif
            </div>
            <div class="col-md-9">
                <div class="company-name">{{ $loan->partner->company_name ?? $loan->partner->name }}</div>
                <div class="company-details">
                    @if($loan->partner->address)
                        <i class="bi bi-geo-alt"></i> {{ $loan->partner->address }}<br>
                    @endif
                    @if($loan->partner->phone)
                        <i class="bi bi-telephone"></i> {{ $loan->partner->phone }}
                    @endif
                    @if($loan->partner->whatsapp)
                        | <i class="bi bi-whatsapp"></i> {{ $loan->partner->whatsapp }}
                    @endif
                    @if($loan->partner->email)
                        <br><i class="bi bi-envelope"></i> {{ $loan->partner->email }}
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Document Title -->
    <div class="document-title">Loan Sanction Letter</div>

    <!-- Document Body -->
    <div class="document-body">
        <div class="document-section">
            <p><strong>Date:</strong> {{ now()->format('d F Y') }}</p>
            <p><strong>Reference No:</strong> {{ $loan->loan_number }}</p>
        </div>

        <div class="document-section">
            <p><strong>To,</strong></p>
            <p>
                <strong>{{ $loan->customer->name }}</strong><br>
                {{ $loan->customer->customer_code }}<br>
                @if($loan->customer->address)
                    {{ $loan->customer->address }}<br>
                @endif
                @if($loan->customer->phone)
                    Phone: {{ $loan->customer->phone }}<br>
                @endif
                @if($loan->customer->email)
                    Email: {{ $loan->customer->email }}
                @endif
            </p>
        </div>

        <div class="document-section">
            <p><strong>Subject: Sanction of Loan - {{ $loan->loan_number }}</strong></p>
        </div>

        <div class="document-section">
            <p>Dear {{ $loan->customer->name }},</p>
            
            <p>We are pleased to inform you that your loan application has been approved and we are pleased to sanction the following loan facility:</p>
        </div>

        <div class="document-section">
            <table class="info-table">
                <tr>
                    <td>Loan Number:</td>
                    <td><strong>{{ $loan->loan_number }}</strong></td>
                </tr>
                <tr>
                    <td>Loan Scheme:</td>
                    <td>{{ $loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Principal Amount:</td>
                    <td><strong>₹{{ number_format($loan->principal_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td>Interest Rate:</td>
                    <td>{{ $loan->interest_rate }}{{ ($loan->loanScheme?->interest_type ?? $loan->scheme?->interest_type) === 'flat' ? ' (Flat)' : '%' }}</td>
                </tr>
                <tr>
                    <td>Interest Amount:</td>
                    <td>₹{{ number_format($loan->interest_amount, 2) }}</td>
                </tr>
                <tr>
                    <td>Processing Fee:</td>
                    <td>₹{{ number_format($loan->processing_fee, 2) }}</td>
                </tr>
                <tr>
                    <td>Insurance Fee:</td>
                    <td>₹{{ number_format($loan->insurance_fee, 2) }}</td>
                </tr>
                <tr>
                    <td>Other Fees:</td>
                    <td>₹{{ number_format($loan->other_fee, 2) }}</td>
                </tr>
                <tr>
                    <td><strong>Total Loan Amount:</strong></td>
                    <td><strong>₹{{ number_format($loan->total_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td>Loan Duration:</td>
                    <td>{{ $loan->duration_value }} {{ ucfirst($loan->duration_type) }}</td>
                </tr>
                <tr>
                    <td>Installment Amount:</td>
                    <td><strong>₹{{ number_format($loan->monthly_installment, 2) }}</strong></td>
                </tr>
                <tr>
                    <td>Disbursement Date:</td>
                    <td>{{ $loan->disbursement_date->format('d F Y') }}</td>
                </tr>
                <tr>
                    <td>Maturity Date:</td>
                    <td>{{ $loan->maturity_date->format('d F Y') }}</td>
                </tr>
            </table>
        </div>

        <div class="document-section">
            <p><strong>Terms and Conditions:</strong></p>
            <ol>
                <li>The loan amount will be disbursed as per the disbursement date mentioned above.</li>
                <li>You are required to repay the loan in {{ $loan->duration_value }} installments of ₹{{ number_format($loan->monthly_installment, 2) }} each.</li>
                <li>Late payment charges will be applicable as per the scheme terms if payment is delayed beyond the due date.</li>
                <li>You are required to maintain all necessary documents and comply with all terms and conditions of the loan agreement.</li>
                <li>Any default in repayment may result in legal action as per applicable laws.</li>
            </ol>
        </div>

        <div class="document-section">
            <p>Please acknowledge receipt of this sanction letter and confirm your acceptance of the terms and conditions mentioned above.</p>
            
            <p>We look forward to a successful business relationship.</p>
        </div>

        <div class="document-section">
            <p>Yours sincerely,</p>
        </div>

        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line">
                    <strong>{{ $loan->partner->company_name ?? $loan->partner->name }}</strong>
                </div>
            </div>
            <div class="signature-box">
                <div class="signature-line">
                    <strong>Authorized Signatory</strong>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

