@extends('layouts.app')

@section('title', 'Loans')
@section('page-title', 'Loans')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Loans</h5>
        <a href="{{ route('partner.loans.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Loan
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Principal</th>
                        <th>Remaining</th>
                        <th>Due Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($loans as $loan)
                    <tr>
                        <td>{{ $loan->loan_number }}</td>
                        <td>{{ $loan->customer->name }}</td>
                        <td>₹{{ number_format($loan->principal_amount, 2) }}</td>
                        <td>₹{{ number_format($loan->remaining_amount, 2) }}</td>
                        <td>{{ $loan->due_date->format('d M Y') }}</td>
                        <td>
                            <span class="badge bg-{{ $loan->status === 'active' ? 'success' : ($loan->status === 'completed' ? 'info' : 'secondary') }}">
                                {{ ucfirst($loan->status) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('partner.loans.show', $loan) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">No loans found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $loans->links() }}
        </div>
    </div>
</div>
@endsection

