@php
use Illuminate\Support\Facades\Storage;
@endphp
@extends('layouts.app')

@section('title', 'Repayment Schedule')
@section('page-title', 'Repayment Schedule')

@section('content')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        body {
            background: white !important;
        }
    }
    .schedule-header {
        border-bottom: 3px solid #6366f1;
        padding-bottom: 1rem;
        margin-bottom: 2rem;
    }
    .schedule-section {
        margin-bottom: 2rem;
    }
    .schedule-table {
        font-size: 0.9rem;
    }
    .schedule-table th {
        background: #f8f9fa;
        font-weight: 600;
    }
    .status-paid {
        background: #d1e7dd !important;
    }
    .status-overdue {
        background: #f8d7da !important;
    }
    .status-pending {
        background: #fff3cd !important;
    }
</style>

<div class="card no-print mb-3">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Repayment Schedule</h5>
            <div class="d-flex gap-2">
                <button onclick="window.print()" class="btn btn-primary btn-sm">
                    <i class="bi bi-printer"></i> Print
                </button>
                <a href="{{ route('partner.loans.show', $loan) }}" class="btn btn-secondary btn-sm">
                    <i class="bi bi-arrow-left"></i> Back
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <!-- Schedule Header -->
        <div class="schedule-header">
            <div class="row align-items-center mb-3">
                <div class="col-md-3 text-center">
                    @if($loan->partner->logo)
                        <img src="{{ Storage::url($loan->partner->logo) }}" alt="Company Logo" style="max-height: 80px; max-width: 200px; object-fit: contain;">
                    @else
                        <div class="bg-light rounded d-flex align-items-center justify-content-center mx-auto" style="height: 80px; width: 150px;">
                            <i class="bi bi-building text-muted" style="font-size: 2.5rem;"></i>
                        </div>
                    @endif
                </div>
                <div class="col-md-9">
                    <h2 class="mb-2">{{ $loan->partner->company_name ?? $loan->partner->name }}</h2>
                    <div class="text-muted">
                        @if($loan->partner->address)
                            <i class="bi bi-geo-alt"></i> {{ $loan->partner->address }}<br>
                        @endif
                        @if($loan->partner->phone)
                            <i class="bi bi-telephone"></i> {{ $loan->partner->phone }}
                        @endif
                        @if($loan->partner->whatsapp)
                            | <i class="bi bi-whatsapp"></i> {{ $loan->partner->whatsapp }}
                        @endif
                        @if($loan->partner->email)
                            <br><i class="bi bi-envelope"></i> {{ $loan->partner->email }}
                        @endif
                    </div>
                </div>
            </div>
            <div class="text-center">
                <h4 class="text-primary mb-1">Loan Repayment Schedule</h4>
                <p class="text-muted mb-0">Generated on: {{ now()->format('d M Y, h:i A') }}</p>
            </div>
        </div>

        <!-- Loan Information -->
        <div class="schedule-section">
            <h5 class="mb-3">Loan Information</h5>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Loan Number:</strong></td>
                            <td>{{ $loan->loan_number }}</td>
                        </tr>
                        <tr>
                            <td><strong>Customer Name:</strong></td>
                            <td>{{ $loan->customer->name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Customer Code:</strong></td>
                            <td>{{ $loan->customer->customer_code }}</td>
                        </tr>
                        <tr>
                            <td><strong>Phone:</strong></td>
                            <td>{{ $loan->customer->phone }}</td>
                        </tr>
                        <tr>
                            <td><strong>Scheme:</strong></td>
                            <td>{{ $loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Principal Amount:</strong></td>
                            <td>₹{{ number_format($loan->principal_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Total Loan Amount:</strong></td>
                            <td><strong>₹{{ number_format($loan->total_amount, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Installment Amount:</strong></td>
                            <td>₹{{ number_format($loan->monthly_installment, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Duration:</strong></td>
                            <td>{{ $loan->duration_value }} {{ ucfirst($loan->duration_type) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Disbursement Date:</strong></td>
                            <td>{{ $loan->disbursement_date->format('d M Y') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Maturity Date:</strong></td>
                            <td>{{ $loan->maturity_date->format('d M Y') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Paid Amount:</strong></td>
                            <td>₹{{ number_format($loan->paid_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Remaining Amount:</strong></td>
                            <td><strong class="text-danger">₹{{ number_format($loan->remaining_amount, 2) }}</strong></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Repayment Schedule -->
        <div class="schedule-section">
            <h5 class="mb-3">Repayment Schedule</h5>
            <div class="table-responsive">
                <table class="table table-bordered schedule-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Due Date</th>
                            <th class="text-end">Due Amount</th>
                            <th>Payment Date</th>
                            <th class="text-end">Paid Amount</th>
                            <th class="text-end">Remaining Balance</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($schedule as $installment)
                        <tr class="status-{{ $installment['status'] }}">
                            <td>{{ $installment['installment_number'] }}</td>
                            <td>{{ $installment['due_date']->format('d M Y') }}</td>
                            <td class="text-end"><strong>₹{{ number_format($installment['due_amount'], 2) }}</strong></td>
                            <td>
                                @if($installment['paid_date'])
                                    {{ $installment['paid_date']->format('d M Y') }}
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td class="text-end">
                                @if($installment['paid_amount'] > 0)
                                    <span class="text-success">₹{{ number_format($installment['paid_amount'], 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td class="text-end">₹{{ number_format($installment['remaining_balance'], 2) }}</td>
                            <td>
                                @if($installment['status'] === 'paid')
                                    <span class="badge bg-success">
                                        <i class="bi bi-check-circle"></i> Paid
                                    </span>
                                @elseif($installment['status'] === 'overdue')
                                    <span class="badge bg-danger">
                                        <i class="bi bi-exclamation-triangle"></i> Overdue
                                    </span>
                                @else
                                    <span class="badge bg-warning">
                                        <i class="bi bi-clock"></i> Pending
                                    </span>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="table-info">
                            <td colspan="2" class="text-end"><strong>Total:</strong></td>
                            <td class="text-end"><strong>₹{{ number_format($loan->total_amount, 2) }}</strong></td>
                            <td></td>
                            <td class="text-end"><strong>₹{{ number_format($loan->paid_amount, 2) }}</strong></td>
                            <td class="text-end"><strong>₹{{ number_format($loan->remaining_amount, 2) }}</strong></td>
                            <td>
                                @php
                                    $paidCount = collect($schedule)->where('status', 'paid')->count();
                                    $overdueCount = collect($schedule)->where('status', 'overdue')->count();
                                    $pendingCount = collect($schedule)->where('status', 'pending')->count();
                                @endphp
                                <small>
                                    Paid: {{ $paidCount }} | 
                                    Overdue: {{ $overdueCount }} | 
                                    Pending: {{ $pendingCount }}
                                </small>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>

        <!-- Summary -->
        <div class="schedule-section">
            <div class="row">
                <div class="col-md-4">
                    <div class="card bg-success bg-opacity-10">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Paid Installments</h6>
                            <h4 class="mb-0 text-success">
                                {{ collect($schedule)->where('status', 'paid')->count() }} / {{ count($schedule) }}
                            </h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card bg-danger bg-opacity-10">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Overdue Installments</h6>
                            <h4 class="mb-0 text-danger">
                                {{ collect($schedule)->where('status', 'overdue')->count() }}
                            </h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card bg-warning bg-opacity-10">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Pending Installments</h6>
                            <h4 class="mb-0 text-warning">
                                {{ collect($schedule)->where('status', 'pending')->count() }}
                            </h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="schedule-section mt-4 pt-3 border-top">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-1"><strong>Loan Status:</strong> 
                        <span class="badge bg-{{ $loan->status === 'active' ? 'success' : ($loan->status === 'completed' ? 'info' : 'secondary') }}">
                            {{ ucfirst($loan->status) }}
                        </span>
                    </p>
                    <p class="mb-0"><strong>Payment Frequency:</strong> {{ ucfirst($loan->duration_type) }}</p>
                </div>
                <div class="col-md-6 text-end">
                    <p class="mb-0 text-muted"><small>This is a computer-generated repayment schedule.</small></p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

