@php
use Illuminate\Support\Facades\Storage;
@endphp
@extends('layouts.app')

@section('title', 'Loan Repayment Statement')
@section('page-title', 'Loan Repayment Statement')

@section('content')
<style>
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        body {
            background: white !important;
        }
    }
    .statement-header {
        border-bottom: 3px solid #6366f1;
        padding-bottom: 1rem;
        margin-bottom: 2rem;
    }
    .statement-section {
        margin-bottom: 2rem;
    }
    .statement-table {
        font-size: 0.9rem;
    }
    .statement-table th {
        background: #f8f9fa;
        font-weight: 600;
    }
    .total-row {
        font-weight: 700;
        background: #f8f9fa;
    }
</style>

<div class="card no-print mb-3">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Loan Repayment Statement</h5>
            <div class="d-flex gap-2">
                <button onclick="window.print()" class="btn btn-primary btn-sm">
                    <i class="bi bi-printer"></i> Print
                </button>
                <a href="{{ route('partner.loans.show', $loan) }}" class="btn btn-secondary btn-sm">
                    <i class="bi bi-arrow-left"></i> Back
                </a>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <!-- Statement Header -->
        <div class="statement-header">
            <div class="row align-items-center mb-3">
                <div class="col-md-3 text-center">
                    @if($loan->partner->logo)
                        <img src="{{ Storage::url($loan->partner->logo) }}" alt="Company Logo" style="max-height: 80px; max-width: 200px; object-fit: contain;">
                    @else
                        <div class="bg-light rounded d-flex align-items-center justify-content-center mx-auto" style="height: 80px; width: 150px;">
                            <i class="bi bi-building text-muted" style="font-size: 2.5rem;"></i>
                        </div>
                    @endif
                </div>
                <div class="col-md-9">
                    <h2 class="mb-2">{{ $loan->partner->company_name ?? $loan->partner->name }}</h2>
                    <div class="text-muted">
                        @if($loan->partner->address)
                            <i class="bi bi-geo-alt"></i> {{ $loan->partner->address }}<br>
                        @endif
                        @if($loan->partner->phone)
                            <i class="bi bi-telephone"></i> {{ $loan->partner->phone }}
                        @endif
                        @if($loan->partner->whatsapp)
                            | <i class="bi bi-whatsapp"></i> {{ $loan->partner->whatsapp }}
                        @endif
                        @if($loan->partner->email)
                            <br><i class="bi bi-envelope"></i> {{ $loan->partner->email }}
                        @endif
                    </div>
                </div>
            </div>
            <div class="text-center">
                <h4 class="text-primary mb-1">Loan Repayment Statement</h4>
                <p class="text-muted mb-0">Generated on: {{ now()->format('d M Y, h:i A') }}</p>
            </div>
        </div>

        <!-- Loan Information -->
        <div class="statement-section">
            <h5 class="mb-3">Loan Information</h5>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Loan Number:</strong></td>
                            <td>{{ $loan->loan_number }}</td>
                        </tr>
                        <tr>
                            <td><strong>Customer Name:</strong></td>
                            <td>{{ $loan->customer->name }}</td>
                        </tr>
                        <tr>
                            <td><strong>Customer Code:</strong></td>
                            <td>{{ $loan->customer->customer_code }}</td>
                        </tr>
                        <tr>
                            <td><strong>Phone:</strong></td>
                            <td>{{ $loan->customer->phone }}</td>
                        </tr>
                        <tr>
                            <td><strong>Scheme:</strong></td>
                            <td>{{ $loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-sm table-borderless">
                        <tr>
                            <td width="40%"><strong>Principal Amount:</strong></td>
                            <td>₹{{ number_format($loan->principal_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Interest Rate:</strong></td>
                            <td>{{ $loan->interest_rate }}{{ ($loan->loanScheme?->interest_type ?? $loan->scheme?->interest_type) === 'flat' ? ' (Flat)' : '%' }}</td>
                        </tr>
                        <tr>
                            <td><strong>Interest Amount:</strong></td>
                            <td>₹{{ number_format($loan->interest_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Processing Fee:</strong></td>
                            <td>₹{{ number_format($loan->processing_fee, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Insurance Fee:</strong></td>
                            <td>₹{{ number_format($loan->insurance_fee, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Other Fee:</strong></td>
                            <td>₹{{ number_format($loan->other_fee, 2) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Total Loan Amount:</strong></td>
                            <td><strong>₹{{ number_format($loan->total_amount, 2) }}</strong></td>
                        </tr>
                        <tr>
                            <td><strong>Duration:</strong></td>
                            <td>{{ $loan->duration_value }} {{ ucfirst($loan->duration_type) }}</td>
                        </tr>
                        <tr>
                            <td><strong>Disbursement Date:</strong></td>
                            <td>{{ $loan->disbursement_date->format('d M Y') }}</td>
                        </tr>
                        <tr>
                            <td><strong>Maturity Date:</strong></td>
                            <td>{{ $loan->maturity_date->format('d M Y') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <!-- Repayment Summary -->
        <div class="statement-section">
            <h5 class="mb-3">Repayment Summary</h5>
            <div class="row mb-3">
                <div class="col-md-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Total Paid</h6>
                            <h4 class="mb-0 text-primary">₹{{ number_format($totalPaid, 2) }}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Principal Paid</h6>
                            <h4 class="mb-0 text-success">₹{{ number_format($totalPrincipal, 2) }}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Interest Paid</h6>
                            <h4 class="mb-0 text-info">₹{{ number_format($totalInterest, 2) }}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-light">
                        <div class="card-body text-center">
                            <h6 class="text-muted mb-1">Remaining</h6>
                            <h4 class="mb-0 text-danger">₹{{ number_format($loan->remaining_amount, 2) }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Repayment Details -->
        <div class="statement-section">
            <h5 class="mb-3">Repayment Details</h5>
            <div class="table-responsive">
                <table class="table table-bordered statement-table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Repayment #</th>
                            <th>Payment Date</th>
                            <th>Due Date</th>
                            <th class="text-end">Total Amount</th>
                            <th class="text-end">Principal</th>
                            <th class="text-end">Interest</th>
                            <th class="text-end">Penalty</th>
                            <th>Payment Method</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($loan->repayments as $index => $repayment)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $repayment->repayment_number }}</td>
                            <td>{{ $repayment->payment_date->format('d M Y') }}</td>
                            <td>{{ $repayment->due_date->format('d M Y') }}</td>
                            <td class="text-end">₹{{ number_format($repayment->amount, 2) }}</td>
                            <td class="text-end">₹{{ number_format($repayment->principal_amount, 2) }}</td>
                            <td class="text-end">₹{{ number_format($repayment->interest_amount, 2) }}</td>
                            <td class="text-end">₹{{ number_format($repayment->penalty_amount, 2) }}</td>
                            <td>{{ ucfirst(str_replace('_', ' ', $repayment->payment_method)) }}</td>
                            <td>
                                <span class="badge bg-{{ $repayment->status === 'on_time' ? 'success' : ($repayment->status === 'overdue' ? 'danger' : 'warning') }}">
                                    {{ ucfirst(str_replace('_', ' ', $repayment->status)) }}
                                </span>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10" class="text-center py-4">
                                <i class="bi bi-inbox text-muted" style="font-size: 2rem;"></i>
                                <p class="text-muted mb-0 mt-2">No repayments recorded yet.</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                    @if($loan->repayments->count() > 0)
                    <tfoot>
                        <tr class="total-row">
                            <td colspan="4" class="text-end"><strong>Total:</strong></td>
                            <td class="text-end"><strong>₹{{ number_format($totalPaid, 2) }}</strong></td>
                            <td class="text-end"><strong>₹{{ number_format($totalPrincipal, 2) }}</strong></td>
                            <td class="text-end"><strong>₹{{ number_format($totalInterest, 2) }}</strong></td>
                            <td class="text-end"><strong>₹{{ number_format($totalPenalty, 2) }}</strong></td>
                            <td colspan="2"></td>
                        </tr>
                    </tfoot>
                    @endif
                </table>
            </div>
        </div>

        <!-- Footer -->
        <div class="statement-section mt-4 pt-3 border-top">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-1"><strong>Loan Status:</strong> 
                        <span class="badge bg-{{ $loan->status === 'active' ? 'success' : ($loan->status === 'completed' ? 'info' : 'secondary') }}">
                            {{ ucfirst($loan->status) }}
                        </span>
                    </p>
                    <p class="mb-0"><strong>Installment Amount:</strong> ₹{{ number_format($loan->monthly_installment, 2) }}</p>
                </div>
                <div class="col-md-6 text-end">
                    <p class="mb-0 text-muted"><small>This is a computer-generated statement.</small></p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

