@extends('layouts.app')

@section('title', 'Penalties')
@section('page-title', 'Penalties')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Penalties</h5>
        <a href="{{ route('partner.penalties.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add Penalty
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Penalty #</th>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Days Overdue</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($penalties as $penalty)
                    <tr>
                        <td>{{ $penalty->penalty_number }}</td>
                        <td>{{ $penalty->loan->loan_number }}</td>
                        <td>{{ $penalty->customer->name }}</td>
                        <td>₹{{ number_format($penalty->amount, 2) }}</td>
                        <td>{{ $penalty->days_overdue }}</td>
                        <td>
                            <span class="badge bg-{{ $penalty->status === 'paid' ? 'success' : ($penalty->status === 'waived' ? 'info' : 'warning') }}">
                                {{ ucfirst($penalty->status) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('partner.penalties.show', $penalty) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">No penalties found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $penalties->links() }}
        </div>
    </div>
</div>
@endsection

