@extends('layouts.app')

@section('title', 'Repayments')
@section('page-title', 'Repayments')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Repayments</h5>
        <a href="{{ route('partner.repayments.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Record Repayment
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Repayment #</th>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Payment Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($repayments as $repayment)
                    <tr>
                        <td>{{ $repayment->repayment_number }}</td>
                        <td>{{ $repayment->loan->loan_number }}</td>
                        <td>{{ $repayment->customer->name }}</td>
                        <td>₹{{ number_format($repayment->amount, 2) }}</td>
                        <td>{{ $repayment->payment_date->format('d M Y') }}</td>
                        <td>
                            <span class="badge bg-{{ $repayment->status === 'on_time' ? 'success' : 'warning' }}">
                                {{ ucfirst(str_replace('_', ' ', $repayment->status)) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('partner.repayments.show', $repayment) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">No repayments found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $repayments->links() }}
        </div>
    </div>
</div>
@endsection

