@extends('layouts.app')

@section('title', 'Repayment Details')
@section('page-title', 'Repayment Details')

@section('content')
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Repayment Information</h5>
        <a href="{{ route('partner.repayments.index') }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left"></i> Back
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>Repayment Number:</strong> {{ $repayment->repayment_number }}</p>
                <p><strong>Loan Number:</strong> {{ $repayment->loan->loan_number }}</p>
                <p><strong>Customer:</strong> {{ $repayment->customer->name }}</p>
                <p><strong>Total Amount:</strong> ₹{{ number_format($repayment->amount, 2) }}</p>
            </div>
            <div class="col-md-6">
                <p><strong>Principal:</strong> ₹{{ number_format($repayment->principal_amount, 2) }}</p>
                <p><strong>Interest:</strong> ₹{{ number_format($repayment->interest_amount, 2) }}</p>
                <p><strong>Penalty:</strong> ₹{{ number_format($repayment->penalty_amount, 2) }}</p>
                <p><strong>Payment Date:</strong> {{ $repayment->payment_date->format('d M Y') }}</p>
                <p><strong>Payment Method:</strong> {{ ucfirst(str_replace('_', ' ', $repayment->payment_method)) }}</p>
                <p><strong>Status:</strong> 
                    <span class="badge bg-{{ $repayment->status === 'on_time' ? 'success' : 'warning' }}">
                        {{ ucfirst(str_replace('_', ' ', $repayment->status)) }}
                    </span>
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

