@extends('layouts.app')

@section('title', 'Savings Maturity Report')
@section('page-title', 'Savings Maturity Report')

@section('content')
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('partner.reports.savings-maturity') }}" class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">Maturity Status</label>
                <select name="maturity_status" class="form-select">
                    <option value="">All</option>
                    <option value="matured" {{ request('maturity_status') === 'matured' ? 'selected' : '' }}>Matured</option>
                    <option value="upcoming" {{ request('maturity_status') === 'upcoming' ? 'selected' : '' }}>Upcoming</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="{{ route('partner.reports.savings-maturity') }}" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Accounts</h6>
                <h3 style="color: var(--text-heading);">{{ $summary['total_accounts'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Matured</h6>
                <h3 style="color: var(--info);">{{ $summary['matured_accounts'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Upcoming</h6>
                <h3 style="color: var(--warning);">{{ $summary['upcoming_accounts'] }}</h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Amount</h6>
                <h3 style="color: var(--text-heading);">₹{{ number_format($summary['total_maturity_amount'], 2) }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Savings Maturity Details</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Savings #</th>
                        <th>Customer</th>
                        <th>Scheme</th>
                        <th>Deposit Date</th>
                        <th>Maturity Date</th>
                        <th class="text-end">Amount</th>
                        <th class="text-end">Days Until Maturity</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($savings as $saving)
                    <tr class="{{ $saving->is_matured ? 'table-info' : '' }}">
                        <td>{{ $saving->savings_number }}</td>
                        <td>{{ $saving->customer->name }}</td>
                        <td>{{ $saving->scheme->name ?? 'N/A' }}</td>
                        <td>{{ $saving->deposit_date->format('d M Y') }}</td>
                        <td>{{ $saving->maturity_date->format('d M Y') }}</td>
                        <td class="text-end">₹{{ number_format($saving->amount, 2) }}</td>
                        <td class="text-end">
                            @if($saving->is_matured)
                                <span class="badge bg-info">Matured</span>
                            @else
                                <span class="badge bg-warning">{{ $saving->days_until_maturity }} days</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $saving->is_matured ? 'info' : 'success' }}">
                                {{ $saving->is_matured ? 'Matured' : 'Active' }}
                            </span>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No savings found</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection



