@extends('layouts.app')

@section('title', 'Savings Collections')
@section('page-title', 'Savings Collections')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Savings Collections</h5>
        <a href="{{ route('partner.savings-collections.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Record Collection
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Collection #</th>
                        <th>Savings Account</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Collection Date</th>
                        <th>Payment Method</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($collections as $collection)
                    <tr>
                        <td>{{ $collection->collection_number }}</td>
                        <td>{{ $collection->savingsAccount->savings_number }}</td>
                        <td>{{ $collection->customer->name }}</td>
                        <td>₹{{ number_format($collection->amount, 2) }}</td>
                        <td>{{ $collection->collection_date->format('d M Y') }}</td>
                        <td><span class="badge bg-info">{{ ucfirst(str_replace('_', ' ', $collection->payment_method)) }}</span></td>
                        <td>
                            <a href="{{ route('partner.savings-collections.show', $collection) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">No collections found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $collections->links() }}
        </div>
    </div>
</div>
@endsection

