@extends('layouts.app')

@section('title', 'Savings')
@section('page-title', 'Savings')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Savings Accounts</h5>
        <a href="{{ route('partner.savings.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Account
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Savings #</th>
                        <th>Customer</th>
                        <th>Type</th>
                        <th>Principal/Monthly</th>
                        <th>Maturity Amount</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($savings as $saving)
                    <tr>
                        <td>{{ $saving->savings_number }}</td>
                        <td>{{ $saving->customer->name }}</td>
                        <td>
                            <span class="badge bg-{{ $saving->savings_type === 'RD' ? 'primary' : ($saving->savings_type === 'FD' ? 'success' : 'warning') }}">
                                {{ $saving->savings_type ?? 'RD' }}
                            </span>
                        </td>
                        <td>
                            @if($saving->savings_type === 'RD')
                                ₹{{ number_format($saving->monthly_deposit ?? 0, 2) }}/month
                            @elseif($saving->savings_type === 'FD' || $saving->savings_type === 'MIS')
                                ₹{{ number_format($saving->principal_amount ?? 0, 2) }}
                            @else
                                ₹{{ number_format($saving->amount, 2) }}
                            @endif
                        </td>
                        <td>
                            <strong class="text-success">
                                ₹{{ number_format($saving->maturity_amount ?? 0, 2) }}
                            </strong>
                        </td>
                        <td>{{ $saving->deposit_date->format('d M Y') }}</td>
                        <td>
                            <span class="badge bg-{{ $saving->status === 'active' ? 'success' : ($saving->status === 'matured' ? 'info' : 'secondary') }}">
                                {{ ucfirst($saving->status) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('partner.savings.show', $saving) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">No savings accounts found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $savings->links() }}
        </div>
    </div>
</div>
@endsection

