@extends('layouts.app')

@section('title', 'Edit Scheme')
@section('page-title', 'Edit Scheme')

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Edit Scheme</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('partner.schemes.update', $scheme) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="name" class="form-label">Name *</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $scheme->name) }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="type" class="form-label">Type *</label>
                    <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                        <option value="loan" {{ old('type', $scheme->type) === 'loan' ? 'selected' : '' }}>Loan</option>
                        <option value="savings" {{ old('type', $scheme->type) === 'savings' ? 'selected' : '' }}>Savings</option>
                    </select>
                    @error('type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="interest_type" class="form-label">Interest Type *</label>
                    <select class="form-select @error('interest_type') is-invalid @enderror" id="interest_type" name="interest_type" required>
                        <option value="percentage" {{ old('interest_type', $scheme->interest_type ?? 'percentage') === 'percentage' ? 'selected' : '' }}>Percentage (%)</option>
                        <option value="flat" {{ old('interest_type', $scheme->interest_type ?? '') === 'flat' ? 'selected' : '' }}>Flat Amount</option>
                    </select>
                    @error('interest_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="interest_rate" class="form-label">Interest Rate/Amount *</label>
                    <input type="number" step="0.01" class="form-control @error('interest_rate') is-invalid @enderror" 
                           id="interest_rate" name="interest_rate" value="{{ old('interest_rate', $scheme->interest_rate) }}" 
                           placeholder="Enter rate or amount" required>
                    @error('interest_rate')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="duration_type" class="form-label">Duration Type</label>
                    <select class="form-select" id="duration_type" name="duration_type">
                        <option value="">Select Type</option>
                        <option value="daily" {{ old('duration_type', $scheme->duration_type ?? '') === 'daily' ? 'selected' : '' }}>Daily</option>
                        <option value="weekly" {{ old('duration_type', $scheme->duration_type ?? '') === 'weekly' ? 'selected' : '' }}>Weekly</option>
                        <option value="monthly" {{ old('duration_type', $scheme->duration_type ?? '') === 'monthly' ? 'selected' : '' }}>Monthly</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="duration_value" class="form-label">Duration Value</label>
                    <input type="number" class="form-control" id="duration_value" name="duration_value" 
                           value="{{ old('duration_value', $scheme->duration_value ?? '') }}" placeholder="e.g., 30">
                </div>
                <div class="col-md-4 mb-3">
                    <label for="duration_months" class="form-label">Duration (Months) - Legacy</label>
                    <input type="number" class="form-control" id="duration_months" name="duration_months" 
                           value="{{ old('duration_months', $scheme->duration_months ?? '') }}" placeholder="Optional">
                </div>
            </div>
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="processing_fee" class="form-label">Processing Fee</label>
                    <input type="number" step="0.01" class="form-control @error('processing_fee') is-invalid @enderror" 
                           id="processing_fee" name="processing_fee" value="{{ old('processing_fee', $scheme->processing_fee ?? 0) }}" min="0">
                    @error('processing_fee')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label for="insurance_fee" class="form-label">Insurance Fee</label>
                    <input type="number" step="0.01" class="form-control @error('insurance_fee') is-invalid @enderror" 
                           id="insurance_fee" name="insurance_fee" value="{{ old('insurance_fee', $scheme->insurance_fee ?? 0) }}" min="0">
                    @error('insurance_fee')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-4 mb-3">
                    <label for="other_fee" class="form-label">Other Fee</label>
                    <input type="number" step="0.01" class="form-control @error('other_fee') is-invalid @enderror" 
                           id="other_fee" name="other_fee" value="{{ old('other_fee', $scheme->other_fee ?? 0) }}" min="0">
                    @error('other_fee')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="late_fee_type" class="form-label">Late Fee Type</label>
                    <select class="form-select @error('late_fee_type') is-invalid @enderror" id="late_fee_type" name="late_fee_type">
                        <option value="">No Late Fee</option>
                        <option value="percentage" {{ old('late_fee_type', $scheme->late_fee_type ?? '') === 'percentage' ? 'selected' : '' }}>Percentage (%)</option>
                        <option value="fixed" {{ old('late_fee_type', $scheme->late_fee_type ?? '') === 'fixed' ? 'selected' : '' }}>Fixed Amount</option>
                    </select>
                    @error('late_fee_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted">Late fee will be automatically applied for overdue payments</small>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="late_fee_value" class="form-label">Late Fee Value</label>
                    <input type="number" step="0.01" class="form-control @error('late_fee_value') is-invalid @enderror" 
                           id="late_fee_value" name="late_fee_value" value="{{ old('late_fee_value', $scheme->late_fee_value ?? 0) }}" 
                           placeholder="Enter % or fixed amount" min="0">
                    @error('late_fee_value')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" id="late_fee_hint">If percentage, enter rate (e.g., 5 for 5%)</small>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="min_amount" class="form-label">Min Amount *</label>
                    <input type="number" step="0.01" class="form-control @error('min_amount') is-invalid @enderror" 
                           id="min_amount" name="min_amount" value="{{ old('min_amount', $scheme->min_amount) }}" required>
                    @error('min_amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="max_amount" class="form-label">Max Amount</label>
                    <input type="number" step="0.01" class="form-control" id="max_amount" name="max_amount" value="{{ old('max_amount', $scheme->max_amount) }}">
                </div>
            </div>
            <div class="mb-3">
                <label for="description" class="form-label">Description</label>
                <textarea class="form-control" id="description" name="description" rows="3">{{ old('description', $scheme->description) }}</textarea>
            </div>
            <div class="mb-3">
                <label for="status" class="form-label">Status *</label>
                <select class="form-select" id="status" name="status" required>
                    <option value="active" {{ old('status', $scheme->status) === 'active' ? 'selected' : '' }}>Active</option>
                    <option value="inactive" {{ old('status', $scheme->status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
                </select>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-save"></i> Update Scheme
                </button>
                <a href="{{ route('partner.schemes.index') }}" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    document.getElementById('late_fee_type').addEventListener('change', function() {
        const hint = document.getElementById('late_fee_hint');
        const value = this.value;
        
        if (value === 'percentage') {
            hint.textContent = 'If percentage, enter rate (e.g., 5 for 5% per day of installment amount)';
        } else if (value === 'fixed') {
            hint.textContent = 'Enter fixed amount per day (e.g., 50 for ₹50 per day)';
        } else {
            hint.textContent = 'If percentage, enter rate (e.g., 5 for 5%)';
        }
    });
    
    // Set initial hint text
    const initialType = document.getElementById('late_fee_type').value;
    if (initialType) {
        document.getElementById('late_fee_type').dispatchEvent(new Event('change'));
    }
</script>
@endpush
@endpush

