@extends('layouts.app')

@section('title', 'Schemes')
@section('page-title', 'Schemes')

@section('content')
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Schemes</h5>
        <a href="{{ route('partner.schemes.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Scheme
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Type</th>
                        <th>Interest Rate</th>
                        <th>Min Amount</th>
                        <th>Max Amount</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($schemes as $scheme)
                    <tr>
                        <td>{{ $scheme->name }}</td>
                        <td><span class="badge bg-info">{{ ucfirst($scheme->type) }}</span></td>
                        <td>{{ $scheme->interest_rate }}%</td>
                        <td>₹{{ number_format($scheme->min_amount, 2) }}</td>
                        <td>₹{{ number_format($scheme->max_amount ?? 0, 2) }}</td>
                        <td>
                            <span class="badge bg-{{ $scheme->status === 'active' ? 'success' : 'secondary' }}">
                                {{ ucfirst($scheme->status) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('partner.schemes.show', $scheme) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="{{ route('partner.schemes.edit', $scheme) }}" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">No schemes found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $schemes->links() }}
        </div>
    </div>
</div>
@endsection

