@extends('layouts.app')

@section('title', 'Subscription')
@section('page-title', 'Subscription Plans')

@section('content')
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(!$razorpayConfigured)
<div class="alert alert-warning">
    <i class="bi bi-exclamation-triangle-fill me-2"></i>
    <strong>Payment Gateway Not Configured!</strong> 
    The payment gateway is not set up yet. Please contact the administrator to configure Razorpay API credentials.
</div>
@endif

<!-- Active Subscription Card -->
@if($activeSubscription)
<div class="card mb-4" style="border-left: 4px solid var(--success);">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h5 class="mb-2">
                    <i class="bi bi-check-circle-fill text-success me-2"></i>
                    Active Subscription
                </h5>
                <p class="mb-1">
                    <strong>Plan:</strong> {{ ucfirst($activeSubscription->plan_type) }} 
                    (₹{{ number_format($activeSubscription->amount, 2) }})
                </p>
                <p class="mb-1">
                    <strong>Start Date:</strong> {{ $activeSubscription->start_date->format('d M Y') }}
                </p>
                <p class="mb-0">
                    <strong>End Date:</strong> {{ $activeSubscription->end_date->format('d M Y') }}
                    <span class="badge bg-info ms-2">
                        {{ now()->diffInDays($activeSubscription->end_date) }} days remaining
                    </span>
                </p>
            </div>
        </div>
    </div>
</div>
@else
<div class="alert alert-danger">
    <i class="bi bi-exclamation-triangle-fill me-2"></i>
    <strong>No Active Subscription!</strong> 
    <p class="mb-0 mt-2">Your subscription has expired or is inactive. Please subscribe to continue using the platform. All features are currently locked until you have an active subscription.</p>
</div>
@endif

<!-- Subscription Plans -->
<div class="row mb-4">
    <div class="col-lg-6 mb-4">
        <div class="card h-100">
            <div class="card-header text-center" style="background: linear-gradient(135deg, #7367f0 0%, #9e95f5 100%);">
                <h4 class="text-white mb-0">Monthly Plan</h4>
            </div>
            <div class="card-body text-center">
                <div class="mb-4">
                    <h2 class="mb-0" style="color: var(--text-heading);">₹300</h2>
                    <p class="text-muted mb-0">per month</p>
                </div>
                <ul class="list-unstyled text-start mb-4">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        Full access to all features
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        Unlimited customers & loans
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        All reports & analytics
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        Customer support
                    </li>
                </ul>
                @if($razorpayConfigured)
                    <a href="{{ route('partner.subscription.create', ['plan' => 'monthly']) }}" class="btn btn-primary w-100">
                        <i class="bi bi-credit-card me-2"></i>Subscribe Now
                    </a>
                @else
                    <button class="btn btn-primary w-100" disabled title="Payment gateway not configured">
                        <i class="bi bi-credit-card me-2"></i>Subscribe Now (Unavailable)
                    </button>
                @endif
            </div>
        </div>
    </div>

    <div class="col-lg-6 mb-4">
        <div class="card h-100" style="border: 2px solid var(--warning); position: relative;">
            <div class="position-absolute top-0 end-0 m-2">
                <span class="badge bg-warning text-dark">Best Value</span>
            </div>
            <div class="card-header text-center" style="background: linear-gradient(135deg, #ff9f43 0%, #ffb976 100%);">
                <h4 class="text-white mb-0">Yearly Plan</h4>
            </div>
            <div class="card-body text-center">
                <div class="mb-4">
                    <h2 class="mb-0" style="color: var(--text-heading);">₹3,240</h2>
                    <p class="text-muted mb-0">
                        <del>₹3,600</del> 
                        <span class="text-success">Save 10%</span>
                    </p>
                    <small class="text-muted">₹270 per month</small>
                </div>
                <ul class="list-unstyled text-start mb-4">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        Full access to all features
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        Unlimited customers & loans
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        All reports & analytics
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        Customer support
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-star-fill text-warning me-2"></i>
                        <strong>10% Discount</strong>
                    </li>
                </ul>
                @if($razorpayConfigured)
                    <a href="{{ route('partner.subscription.create', ['plan' => 'yearly']) }}" class="btn btn-warning w-100">
                        <i class="bi bi-credit-card me-2"></i>Subscribe Now
                    </a>
                @else
                    <button class="btn btn-warning w-100" disabled title="Payment gateway not configured">
                        <i class="bi bi-credit-card me-2"></i>Subscribe Now (Unavailable)
                    </button>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Subscription History -->
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Subscription History</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Plan</th>
                        <th>Amount</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Payment Date</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($subscriptions as $subscription)
                    <tr>
                        <td>
                            <span class="badge bg-{{ $subscription->plan_type === 'yearly' ? 'warning' : 'primary' }}">
                                {{ ucfirst($subscription->plan_type) }}
                            </span>
                        </td>
                        <td>₹{{ number_format($subscription->amount, 2) }}</td>
                        <td>{{ $subscription->start_date ? $subscription->start_date->format('d M Y') : 'N/A' }}</td>
                        <td>{{ $subscription->end_date ? $subscription->end_date->format('d M Y') : 'N/A' }}</td>
                        <td>
                            <span class="badge bg-{{ $subscription->status === 'active' ? 'success' : ($subscription->status === 'pending' ? 'warning' : 'secondary') }}">
                                {{ ucfirst($subscription->status) }}
                            </span>
                        </td>
                        <td>{{ $subscription->paid_at ? $subscription->paid_at->format('d M Y H:i') : 'N/A' }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No subscription history</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

