@extends('layouts.app')

@section('title', 'Payment')
@section('page-title', 'Complete Payment')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header text-center">
                <h5 class="card-title mb-0">Complete Your Payment</h5>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <h4>₹{{ number_format($amount, 2) }}</h4>
                    <p class="text-muted mb-0">{{ ucfirst($subscription->plan_type) }} Subscription</p>
                </div>

                <form action="{{ route('partner.subscription.callback') }}" method="POST" id="payment-form">
                    @csrf
                    <input type="hidden" name="razorpay_order_id" value="{{ $razorpayOrder['id'] }}">
                    <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
                    <input type="hidden" name="razorpay_signature" id="razorpay_signature">

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-primary btn-lg" id="pay-button">
                            <i class="bi bi-credit-card me-2"></i>Pay ₹{{ number_format($amount, 2) }}
                        </button>
                        <a href="{{ route('partner.subscription.index') }}" class="btn btn-secondary">
                            Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script>
    var options = {
        "key": "{{ \App\Models\Setting::get('razorpay_key') ?: config('services.razorpay.key') }}",
        "amount": {{ $razorpayOrder['amount'] }},
        "currency": "INR",
        "name": "{{ auth()->user()->partner->company_name ?? auth()->user()->partner->name }}",
        "description": "{{ ucfirst($subscription->plan_type) }} Subscription",
        "order_id": "{{ $razorpayOrder['id'] }}",
        "handler": function (response) {
            document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
            document.getElementById('razorpay_signature').value = response.razorpay_signature;
            document.getElementById('payment-form').submit();
        },
        "prefill": {
            "name": "{{ auth()->user()->name }}",
            "email": "{{ auth()->user()->email }}",
            "contact": "{{ auth()->user()->partner->phone ?? '' }}"
        },
        "theme": {
            "color": "#7367f0"
        },
        "modal": {
            "ondismiss": function() {
                window.location.href = "{{ route('partner.subscription.index') }}";
            }
        }
    };

    var rzp = new Razorpay(options);

    document.getElementById('pay-button').onclick = function(e) {
        e.preventDefault();
        rzp.open();
    };
</script>
@endsection

