@extends('layouts.app')

@section('title', 'Payment Success')
@section('page-title', 'Payment Successful')

@section('content')
<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="card text-center">
            <div class="card-body py-5">
                <div class="mb-4">
                    <i class="bi bi-check-circle-fill" style="font-size: 80px; color: var(--success);"></i>
                </div>
                <h3 class="mb-3">Payment Successful!</h3>
                <p class="text-muted mb-4">Your subscription has been activated successfully.</p>

                <div class="card mb-4" style="background: var(--hover-bg);">
                    <div class="card-body text-start">
                        <h6 class="mb-3">Subscription Details</h6>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Plan:</span>
                            <strong>{{ ucfirst($subscription->plan_type) }}</strong>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Amount:</span>
                            <strong>₹{{ number_format($subscription->amount, 2) }}</strong>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Start Date:</span>
                            <strong>{{ $subscription->start_date->format('d M Y') }}</strong>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="text-muted">End Date:</span>
                            <strong>{{ $subscription->end_date->format('d M Y') }}</strong>
                        </div>
                    </div>
                </div>

                <div class="d-grid gap-2">
                    <a href="{{ route('partner.dashboard') }}" class="btn btn-primary">
                        <i class="bi bi-house me-2"></i>Go to Dashboard
                    </a>
                    <a href="{{ route('partner.subscription.index') }}" class="btn btn-outline-secondary">
                        View Subscription
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


