<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\PartnerController as AdminPartnerController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Partner\DashboardController as PartnerDashboardController;
use App\Http\Controllers\Partner\CustomerController;
use App\Http\Controllers\Partner\LoanController;
use App\Http\Controllers\Partner\SavingController;
use App\Http\Controllers\Partner\RepaymentController;
use App\Http\Controllers\Partner\SchemeController;
use App\Http\Controllers\Partner\PenaltyController;

// Public routes
Route::get('/', function () {
    return redirect()->route('login');
});

Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Theme toggle (requires authentication)
Route::middleware('auth')->post('/theme/toggle', [\App\Http\Controllers\ThemeController::class, 'toggle'])->name('theme.toggle');

// Admin routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
    
    Route::resource('partners', AdminPartnerController::class);
    
    // Subscriptions
    Route::prefix('subscriptions')->name('subscriptions.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\SubscriptionController::class, 'index'])->name('index');
        Route::get('create', [\App\Http\Controllers\Admin\SubscriptionController::class, 'create'])->name('create');
        Route::post('/', [\App\Http\Controllers\Admin\SubscriptionController::class, 'store'])->name('store');
        Route::get('{subscription}', [\App\Http\Controllers\Admin\SubscriptionController::class, 'show'])->name('show');
        Route::put('{subscription}/status', [\App\Http\Controllers\Admin\SubscriptionController::class, 'updateStatus'])->name('update-status');
        Route::get('revenue', [\App\Http\Controllers\Admin\SubscriptionController::class, 'revenue'])->name('revenue');
        Route::get('upcoming-renewals', [\App\Http\Controllers\Admin\SubscriptionController::class, 'upcomingRenewals'])->name('upcoming-renewals');
    });
    
    // Razorpay Settings
    Route::get('razorpay-settings', [\App\Http\Controllers\Admin\RazorpaySettingsController::class, 'index'])->name('razorpay-settings.index');
    Route::put('razorpay-settings', [\App\Http\Controllers\Admin\RazorpaySettingsController::class, 'update'])->name('razorpay-settings.update');
});

// Partner routes
Route::middleware(['auth', 'partner', 'subscription'])->prefix('partner')->name('partner.')->group(function () {
    Route::get('/dashboard', [PartnerDashboardController::class, 'index'])->name('dashboard');
    
    Route::resource('customers', CustomerController::class);
    Route::resource('loans', LoanController::class);
    Route::get('loans/{loan}/statement', [LoanController::class, 'statement'])->name('loans.statement');
    Route::get('loans/{loan}/schedule', [LoanController::class, 'schedule'])->name('loans.schedule');
    Route::post('loans/{loan}/apply-late-fee', [LoanController::class, 'applyLateFee'])->name('loans.apply-late-fee');
    
    // Loan Documents
    Route::get('loans/{loan}/sanction-letter', [\App\Http\Controllers\Partner\LoanDocumentController::class, 'sanctionLetter'])->name('loans.sanction-letter');
    Route::get('loans/{loan}/noc', [\App\Http\Controllers\Partner\LoanDocumentController::class, 'noc'])->name('loans.noc');
    Route::get('repayments/{repayment}/slip', [\App\Http\Controllers\Partner\LoanDocumentController::class, 'repaymentSlip'])->name('repayments.slip');
    Route::get('repayments/loan/{loanId}/schedule', [RepaymentController::class, 'getSchedule'])->name('repayments.loan.schedule');
    Route::resource('savings', SavingController::class);
    Route::get('savings/customer/{customer}/statement', [SavingController::class, 'statement'])->name('savings.statement');
    Route::resource('repayments', RepaymentController::class);
    
    // Savings Collections
    Route::resource('savings-collections', \App\Http\Controllers\Partner\SavingsCollectionController::class);
    Route::get('savings-collections/saving/{savingId}/schedule', [\App\Http\Controllers\Partner\SavingsCollectionController::class, 'getSchedule'])->name('savings-collections.saving.schedule');
    Route::resource('loan-schemes', \App\Http\Controllers\Partner\LoanSchemeController::class);
    Route::resource('savings-schemes', \App\Http\Controllers\Partner\SavingsSchemeController::class);
    Route::resource('penalties', PenaltyController::class);
    
    // Partner Profile
    Route::get('profile', [\App\Http\Controllers\Partner\ProfileController::class, 'show'])->name('profile.show');
    Route::get('profile/edit', [\App\Http\Controllers\Partner\ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('profile', [\App\Http\Controllers\Partner\ProfileController::class, 'update'])->name('profile.update');
    
    // Number Format Settings
    Route::get('settings', [\App\Http\Controllers\Partner\SettingsController::class, 'index'])->name('settings.index');
    Route::put('settings', [\App\Http\Controllers\Partner\SettingsController::class, 'update'])->name('settings.update');
    
    // Reports
    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Partner\ReportsController::class, 'index'])->name('index');
        Route::get('loans', [\App\Http\Controllers\Partner\ReportsController::class, 'loans'])->name('loans');
        Route::get('repayments', [\App\Http\Controllers\Partner\ReportsController::class, 'repayments'])->name('repayments');
        Route::get('overdue', [\App\Http\Controllers\Partner\ReportsController::class, 'overdue'])->name('overdue');
        Route::get('due', [\App\Http\Controllers\Partner\ReportsController::class, 'due'])->name('due');
        Route::get('savings', [\App\Http\Controllers\Partner\ReportsController::class, 'savings'])->name('savings');
        Route::get('collection', [\App\Http\Controllers\Partner\ReportsController::class, 'collection'])->name('collection');
        Route::get('savings-maturity', [\App\Http\Controllers\Partner\ReportsController::class, 'savingsMaturity'])->name('savings-maturity');
        Route::get('balance-sheet', [\App\Http\Controllers\Partner\ReportsController::class, 'balanceSheet'])->name('balance-sheet');
    });
    
    // Subscription
    Route::prefix('subscription')->name('subscription.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Partner\SubscriptionController::class, 'index'])->name('index');
        Route::get('create', [\App\Http\Controllers\Partner\SubscriptionController::class, 'create'])->name('create');
        Route::post('callback', [\App\Http\Controllers\Partner\SubscriptionController::class, 'callback'])->name('callback');
        Route::get('success/{id}', [\App\Http\Controllers\Partner\SubscriptionController::class, 'success'])->name('success');
    });
});
