<?php $__env->startSection('title', 'Savings Collections'); ?>
<?php $__env->startSection('page-title', 'Savings Collections'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Savings Collections</h5>
        <a href="<?php echo e(route('partner.savings-collections.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Record Collection
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Collection #</th>
                        <th>Savings Account</th>
                        <th>Customer</th>
                        <th>Amount</th>
                        <th>Collection Date</th>
                        <th>Payment Method</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $collections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $collection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($collection->collection_number); ?></td>
                        <td><?php echo e($collection->savingsAccount->savings_number); ?></td>
                        <td><?php echo e($collection->customer->name); ?></td>
                        <td>₹<?php echo e(number_format($collection->amount, 2)); ?></td>
                        <td><?php echo e($collection->collection_date->format('d M Y')); ?></td>
                        <td><span class="badge bg-info"><?php echo e(ucfirst(str_replace('_', ' ', $collection->payment_method))); ?></span></td>
                        <td>
                            <a href="<?php echo e(route('partner.savings-collections.show', $collection)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center">No collections found.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            <?php echo e($collections->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/savings-collections/index.blade.php ENDPATH**/ ?>