

<?php $__env->startSection('title', 'Loans'); ?>
<?php $__env->startSection('page-title', 'Loans'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Loans</h5>
        <a href="<?php echo e(route('partner.loans.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Loan
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Principal</th>
                        <th>Remaining</th>
                        <th>Due Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($loan->loan_number); ?></td>
                        <td><?php echo e($loan->customer->name); ?></td>
                        <td>₹<?php echo e(number_format($loan->principal_amount, 2)); ?></td>
                        <td>₹<?php echo e(number_format($loan->remaining_amount, 2)); ?></td>
                        <td><?php echo e($loan->due_date->format('d M Y')); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($loan->status === 'active' ? 'success' : ($loan->status === 'completed' ? 'info' : 'secondary')); ?>">
                                <?php echo e(ucfirst($loan->status)); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('partner.loans.show', $loan)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center">No loans found.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            <?php echo e($loans->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/loans/index.blade.php ENDPATH**/ ?>