<?php $__env->startSection('title', 'Loan Reports'); ?>
<?php $__env->startSection('page-title', 'Loan Reports'); ?>

<?php $__env->startSection('content'); ?>
<style>
    @media print {
        .no-print { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
    }
</style>

<div class="card no-print mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('partner.reports.loans')); ?>" class="row g-3">
            <div class="col-md-2">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="active" <?php echo e(request('status') === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                    <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Scheme</label>
                <select name="scheme_id" class="form-select">
                    <option value="">All Schemes</option>
                    <?php $__currentLoopData = $schemes ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($scheme->id); ?>" <?php echo e(request('scheme_id') == $scheme->id ? 'selected' : ''); ?>>
                            <?php echo e($scheme->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-search me-2"></i>Filter
                </button>
                <a href="<?php echo e(route('partner.reports.loans')); ?>" class="btn btn-secondary">Reset</a>
                <button type="button" onclick="window.print()" class="btn btn-info">
                    <i class="bi bi-printer me-2"></i>Print
                </button>
            </div>
        </form>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Loans</h6>
                <h3 style="color: var(--text-heading);"><?php echo e($summary['total_loans']); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Disbursed</h6>
                <h3 style="color: var(--text-heading);">₹<?php echo e(number_format($summary['total_disbursed'], 2)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Total Collected</h6>
                <h3 style="color: var(--success);">₹<?php echo e(number_format($summary['total_collected'], 2)); ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card">
            <div class="card-body text-center">
                <h6 class="text-muted mb-2">Outstanding</h6>
                <h3 style="color: var(--warning);">₹<?php echo e(number_format($summary['total_outstanding'], 2)); ?></h3>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Loan Details</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Loan #</th>
                        <th>Customer</th>
                        <th>Scheme</th>
                        <th class="text-end">Principal</th>
                        <th class="text-end">Total Amount</th>
                        <th class="text-end">Paid</th>
                        <th class="text-end">Outstanding</th>
                        <th>Disbursement</th>
                        <th>Maturity</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($loan->loan_number); ?></td>
                        <td><?php echo e($loan->customer->name); ?></td>
                        <td><?php echo e($loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A'); ?></td>
                        <td class="text-end">₹<?php echo e(number_format($loan->principal_amount, 2)); ?></td>
                        <td class="text-end">₹<?php echo e(number_format($loan->total_amount, 2)); ?></td>
                        <td class="text-end text-success">₹<?php echo e(number_format($loan->paid_amount, 2)); ?></td>
                        <td class="text-end text-warning">₹<?php echo e(number_format($loan->remaining_amount, 2)); ?></td>
                        <td><?php echo e($loan->disbursement_date->format('d M Y')); ?></td>
                        <td><?php echo e($loan->maturity_date->format('d M Y')); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($loan->status === 'active' ? 'success' : ($loan->status === 'completed' ? 'info' : 'warning')); ?>">
                                <?php echo e(ucfirst($loan->status)); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="10" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No loans found</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
                <?php if($loans->count() > 0): ?>
                <tfoot>
                    <tr class="table-info">
                        <td colspan="3" class="text-end"><strong>Total:</strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($loans->sum('principal_amount'), 2)); ?></strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($loans->sum('total_amount'), 2)); ?></strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($loans->sum('paid_amount'), 2)); ?></strong></td>
                        <td class="text-end"><strong>₹<?php echo e(number_format($loans->sum('remaining_amount'), 2)); ?></strong></td>
                        <td colspan="3"></td>
                    </tr>
                </tfoot>
                <?php endif; ?>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/reports/loans.blade.php ENDPATH**/ ?>