<?php $__env->startSection('title', 'Loan Schemes'); ?>
<?php $__env->startSection('page-title', 'Loan Schemes'); ?>

<?php $__env->startSection('content'); ?>
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?php echo e(session('error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">All Loan Schemes</h5>
        <a href="<?php echo e(route('partner.loan-schemes.create')); ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> New Loan Scheme
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Interest Rate</th>
                        <th>Duration</th>
                        <th>Min Amount</th>
                        <th>Max Amount</th>
                        <th>Processing Fee</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $schemes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <strong><?php echo e($scheme->name); ?></strong>
                            <?php if($scheme->description): ?>
                                <br><small class="text-muted"><?php echo e(\Illuminate\Support\Str::limit($scheme->description, 50)); ?></small>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($scheme->interest_rate); ?>% (<?php echo e(ucfirst($scheme->interest_type)); ?>)</td>
                        <td><?php echo e($scheme->duration_value); ?> <?php echo e(ucfirst($scheme->duration_type)); ?></td>
                        <td>₹<?php echo e(number_format($scheme->min_amount, 2)); ?></td>
                        <td>₹<?php echo e(number_format($scheme->max_amount ?? 0, 2)); ?></td>
                        <td>₹<?php echo e(number_format($scheme->processing_fee, 2)); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($scheme->status === 'active' ? 'success' : 'secondary'); ?>">
                                <?php echo e(ucfirst($scheme->status)); ?>

                            </span>
                        </td>
                        <td>
                            <div class="btn-group">
                                <a href="<?php echo e(route('partner.loan-schemes.show', $scheme)); ?>" class="btn btn-sm btn-info" title="View">
                                    <i class="bi bi-eye"></i>
                                </a>
                                <a href="<?php echo e(route('partner.loan-schemes.edit', $scheme)); ?>" class="btn btn-sm btn-warning" title="Edit">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <form action="<?php echo e(route('partner.loan-schemes.destroy', $scheme)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this loan scheme?');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                            <p class="text-muted mt-2 mb-0">No loan schemes found</p>
                            <a href="<?php echo e(route('partner.loan-schemes.create')); ?>" class="btn btn-primary mt-3">
                                <i class="bi bi-plus-circle"></i> Create First Loan Scheme
                            </a>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            <?php echo e($schemes->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/loan-schemes/index.blade.php ENDPATH**/ ?>