<?php $__env->startSection('title', 'Partner Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h1 class="page-title">Dashboard</h1>
    <div class="page-breadcrumb">
        <i class="bi bi-house"></i>
        <span>Dashboard</span>
    </div>
</div>

<!-- Congratulations Card -->
<div class="row mb-4 dashboard-row">
    <div class="col-lg-8">
        <div class="card h-100" style="background: linear-gradient(135deg, #7367f0 0%, #9e95f5 100%); border: none;">
            <div class="card-body d-flex flex-column">
                <div class="row flex-grow-1 align-items-center">
                    <div class="col-md-8">
                        <h3 class="text-white mb-2">Welcome back <?php echo e(auth()->user()->name); ?>! 🎉</h3>
                        <p class="text-white opacity-75 mb-3">Here's what's happening with your loans today</p>
                        <h2 class="text-white mb-3">₹<?php echo e(number_format($financials['total_disbursed'], 0)); ?></h2>
                        <p class="text-white opacity-75 small mb-3">Total Disbursed Amount</p>
                        <a href="<?php echo e(route('partner.loans.create')); ?>" class="btn btn-light">
                            <i class="bi bi-plus-circle me-2"></i>Create New Loan
                        </a>
                    </div>
                    <div class="col-md-4 text-center d-none d-md-block">
                        <div style="font-size: 120px;">🎁</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card h-100">
            <div class="card-body text-center d-flex flex-column justify-content-center">
                <div class="mb-3">
                    <i class="bi bi-cash-stack" style="font-size: 60px; color: var(--success);"></i>
                </div>
                <h4 class="mb-2" style="color: var(--text-heading); font-size: 32px; font-weight: 700;">₹<?php echo e(number_format($financials['total_collected'])); ?></h4>
                <p class="mb-0" style="color: var(--text-secondary); font-weight: 500;">Total Collected</p>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-sm-6 mb-3">
        <div class="stat-card">
            <div class="stat-info">
                <div class="stat-label">Total Customers</div>
                <div class="stat-value"><?php echo e(number_format($stats['total_customers'])); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> +<?php echo e(abs($loanGrowth)); ?>%
                </div>
            </div>
            <div class="stat-icon" style="background: rgba(40, 199, 111, 0.1); color: var(--success);">
                <i class="bi bi-people"></i>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-sm-6 mb-3">
        <div class="stat-card">
            <div class="stat-info">
                <div class="stat-label">Total Loans</div>
                <div class="stat-value"><?php echo e(number_format($stats['total_loans'])); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> +<?php echo e(abs($amountGrowth)); ?>%
                </div>
            </div>
            <div class="stat-icon" style="background: rgba(115, 103, 240, 0.1); color: var(--primary);">
                <i class="bi bi-wallet2"></i>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-sm-6 mb-3">
        <div class="stat-card">
            <div class="stat-info">
                <div class="stat-label">Active Loans</div>
                <div class="stat-value"><?php echo e(number_format($stats['active_loans'])); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> Active
                </div>
            </div>
            <div class="stat-icon" style="background: rgba(0, 207, 232, 0.1); color: var(--info);">
                <i class="bi bi-cash-coin"></i>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-sm-6 mb-3">
        <div class="stat-card">
            <div class="stat-info">
                <div class="stat-label">Total Savings</div>
                <div class="stat-value"><?php echo e(number_format($stats['total_savings'])); ?></div>
                <div class="stat-change positive">
                    <i class="bi bi-arrow-up"></i> +8%
                </div>
            </div>
            <div class="stat-icon" style="background: rgba(255, 159, 67, 0.1); color: var(--warning);">
                <i class="bi bi-piggy-bank"></i>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row">
    <!-- Loan Status Chart -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Loan Status</h5>
                <div class="dropdown">
                    <button class="btn btn-sm" style="background: var(--hover-bg); color: var(--text-secondary);">
                        <i class="bi bi-three-dots-vertical"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div id="loanStatusChart"></div>
                <div class="mt-4">
                    <?php
                        $total = $loanStatusData->sum('count');
                        $statusColors = [
                            'active' => ['color' => '#28c76f', 'label' => 'Active'],
                            'completed' => ['color' => '#7367f0', 'label' => 'Completed'],
                            'pending' => ['color' => '#ff9f43', 'label' => 'Pending'],
                        ];
                    ?>
                    <?php $__currentLoopData = $loanStatusData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $percentage = $total > 0 ? round(($status->count / $total) * 100) : 0;
                            $statusInfo = $statusColors[$status->status] ?? ['color' => '#82868b', 'label' => ucfirst($status->status)];
                        ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center">
                                <div style="width: 12px; height: 12px; border-radius: 50%; background: <?php echo e($statusInfo['color']); ?>; margin-right: 12px;"></div>
                                <span><?php echo e($statusInfo['label']); ?></span>
                            </div>
                            <strong style="color: var(--text-heading);"><?php echo e($percentage); ?>%</strong>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Monthly Trends Chart -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Loan & Collection Trends</h5>
                <div class="d-flex gap-3">
                    <div class="d-flex align-items-center">
                        <div style="width: 12px; height: 12px; border-radius: 2px; background: var(--warning); margin-right: 8px;"></div>
                        <span class="small">Loans</span>
                    </div>
                    <div class="d-flex align-items-center">
                        <div style="width: 12px; height: 12px; border-radius: 2px; background: var(--info); margin-right: 8px;"></div>
                        <span class="small">Amount (K)</span>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div id="monthlyTrendsChart"></div>
            </div>
        </div>
    </div>
</div>

<!-- Financial Stats & Recent Loans -->
<div class="row">
    <!-- Financial Statistics -->
    <div class="col-lg-4 mb-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Financial Overview</h5>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <span style="color: var(--text-secondary);">This Month</span>
                        <span class="badge bg-success"><?php echo e($loanGrowth >= 0 ? '+' : ''); ?><?php echo e($loanGrowth); ?>%</span>
                    </div>
                    <div class="d-flex align-items-center mb-3">
                        <div class="position-relative me-3">
                            <svg width="80" height="80">
                                <circle cx="40" cy="40" r="32" fill="none" stroke="rgba(115, 103, 240, 0.1)" stroke-width="8"/>
                                <circle cx="40" cy="40" r="32" fill="none" stroke="#7367f0" stroke-width="8"
                                    stroke-dasharray="<?php echo e(2 * 3.14159 * 32 * 0.68); ?> <?php echo e(2 * 3.14159 * 32); ?>"
                                    stroke-dashoffset="0" stroke-linecap="round" transform="rotate(-90 40 40)"/>
                            </svg>
                        </div>
                        <div>
                            <?php
                                $prevMonthStart = \Carbon\Carbon::now()->subMonth()->startOfMonth();
                                $prevMonthEnd = \Carbon\Carbon::now()->subMonth()->endOfMonth();
                                $currentMonthStart = \Carbon\Carbon::now()->startOfMonth();
                                
                                $currentMonthAmount = \App\Models\Loan::where('partner_id', auth()->user()->partner_id)
                                    ->whereBetween('disbursement_date', [$currentMonthStart, \Carbon\Carbon::now()])
                                    ->sum('principal_amount');
                            ?>
                            <h3 class="mb-0" style="color: var(--text-heading);">₹<?php echo e(number_format($currentMonthAmount / 1000, 1)); ?>K</h3>
                            <p class="small mb-0" style="color: var(--text-secondary);">Disbursed this month</p>
                        </div>
                    </div>
                </div>

                <hr style="border-color: var(--border-color);">

                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-2">
                        <span style="color: var(--text-primary);">Total Disbursed</span>
                        <strong style="color: var(--text-heading);">₹<?php echo e(number_format($financials['total_disbursed'])); ?></strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span style="color: var(--text-primary);">Total Collected</span>
                        <strong class="text-success">₹<?php echo e(number_format($financials['total_collected'])); ?></strong>
                    </div>
                    <div class="d-flex justify-content-between mb-2">
                        <span style="color: var(--text-primary);">To Collect</span>
                        <strong class="text-warning">₹<?php echo e(number_format($financials['total_to_collect'])); ?></strong>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span style="color: var(--text-primary);">Savings Balance</span>
                        <strong class="text-info">₹<?php echo e(number_format($financials['total_savings_balance'])); ?></strong>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Loans -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">Recent Loans</h5>
                <a href="<?php echo e(route('partner.loans.index')); ?>" class="btn btn-sm btn-primary">View All</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Loan #</th>
                                <th>Customer</th>
                                <th>Scheme</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentLoans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <a href="<?php echo e(route('partner.loans.show', $loan)); ?>" class="text-decoration-none">
                                        <?php echo e($loan->loan_number); ?>

                                    </a>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="user-avatar me-2" style="width: 32px; height: 32px; font-size: 12px;">
                                            <?php echo e(substr($loan->customer->name, 0, 1)); ?>

                                        </div>
                                        <span><?php echo e($loan->customer->name); ?></span>
                                    </div>
                                </td>
                                <td><?php echo e($loan->loanScheme?->name ?? $loan->scheme?->name ?? 'N/A'); ?></td>
                                <td><strong style="color: var(--text-heading);">₹<?php echo e(number_format($loan->principal_amount)); ?></strong></td>
                                <td>
                                    <span class="badge bg-<?php echo e($loan->status === 'active' ? 'success' : ($loan->status === 'completed' ? 'info' : 'warning')); ?>">
                                        <?php echo e(ucfirst($loan->status)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($loan->disbursement_date->format('d M Y')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center py-4">
                                    <i class="bi bi-inbox" style="font-size: 2rem; color: var(--text-secondary);"></i>
                                    <p class="mt-2 mb-0" style="color: var(--text-secondary);">No loans yet</p>
                                    <a href="<?php echo e(route('partner.loans.create')); ?>" class="btn btn-sm btn-primary mt-3">
                                        <i class="bi bi-plus-circle me-2"></i>Create First Loan
                                    </a>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    // Loan Status Donut Chart
    var loanStatusOptions = {
        series: [
            <?php $__currentLoopData = $loanStatusData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e($status->count); ?>,
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ],
        chart: {
            type: 'donut',
            height: 280,
            background: 'transparent'
        },
        labels: [
            <?php $__currentLoopData = $loanStatusData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                '<?php echo e(ucfirst($status->status)); ?>',
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        ],
        colors: ['#28c76f', '#7367f0', '#ff9f43'],
        dataLabels: {
            enabled: false
        },
        legend: {
            show: false
        },
        plotOptions: {
            pie: {
                donut: {
                    size: '75%',
                    labels: {
                        show: true,
                        name: {
                            show: true,
                            fontSize: '14px',
                            color: '#b4b7bd'
                        },
                        value: {
                            show: true,
                            fontSize: '24px',
                            fontWeight: 700,
                            color: '#fff'
                        },
                        total: {
                            show: true,
                            label: 'Total Loans',
                            fontSize: '14px',
                            color: '#b4b7bd',
                            formatter: function (w) {
                                return w.globals.seriesTotals.reduce((a, b) => a + b, 0)
                            }
                        }
                    }
                }
            }
        },
        stroke: {
            width: 0
        }
    };

    var loanStatusChart = new ApexCharts(document.querySelector("#loanStatusChart"), loanStatusOptions);
    loanStatusChart.render();

    // Monthly Trends Bar Chart
    var monthlyTrendsOptions = {
        series: [{
            name: 'Loans',
            data: [
                <?php $__currentLoopData = $monthlyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($data['loans']); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]
        }, {
            name: 'Amount (K)',
            data: [
                <?php $__currentLoopData = $monthlyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e(round($data['amount'] / 1000, 1)); ?>,
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]
        }],
        chart: {
            type: 'bar',
            height: 300,
            background: 'transparent',
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: '55%',
                borderRadius: 8
            },
        },
        dataLabels: {
            enabled: false
        },
        colors: ['#ff9f43', '#00cfe8'],
        xaxis: {
            categories: [
                <?php $__currentLoopData = $monthlyData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    '<?php echo e($data['month']); ?>',
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ],
            labels: {
                style: {
                    colors: '#b4b7bd'
                }
            },
            axisBorder: {
                show: false
            },
            axisTicks: {
                show: false
            }
        },
        yaxis: {
            labels: {
                style: {
                    colors: '#b4b7bd'
                }
            }
        },
        grid: {
            borderColor: 'rgba(255,255,255,0.05)',
            strokeDashArray: 5
        },
        legend: {
            show: false
        },
        tooltip: {
            theme: 'dark'
        }
    };

    var monthlyTrendsChart = new ApexCharts(document.querySelector("#monthlyTrendsChart"), monthlyTrendsOptions);
    monthlyTrendsChart.render();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\micro-master\resources\views/partner/dashboard.blade.php ENDPATH**/ ?>